/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image.processing;

import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.sis.image.PixelIterator;
import org.apache.sis.image.processing.CompoundFuture;
import org.apache.sis.pending.jdk.JDK18;
import org.apache.sis.system.CommonExecutor;
import org.apache.sis.util.ArgumentChecks;

public abstract class TiledProcess<R> {
    private static final int MIN_TILE_SIZE = 1000;
    private final AtomicInteger runningThreads;
    private final Task[] tasks;
    private final int yStride;
    private int taskIndex;
    private PixelIterator[] iterators;

    protected TiledProcess(RenderedImage data, int overlapX, int overlapY, PixelIterator.Builder iteratorFactory) {
        ArgumentChecks.ensurePositive((String)"overlapX", (int)overlapX);
        ArgumentChecks.ensurePositive((String)"overlapY", (int)overlapY);
        int width = data.getWidth();
        int height = data.getHeight();
        int numTileX = Math.max(width / 1000, 1);
        int numTileY = Math.max(height / 1000, 1);
        long numTiles = Math.multiplyFull(numTileX, numTileY);
        if (numTiles > (long)CommonExecutor.PARALLELISM) {
            double r = Math.sqrt((double)CommonExecutor.PARALLELISM / (double)numTiles);
            if (numTileX >= numTileY) {
                numTileX = Math.max((int)Math.round((double)numTileX * r), 1);
                numTileY = Math.max(Math.min(CommonExecutor.PARALLELISM / numTileX, numTileY), 1);
            } else {
                numTileY = Math.max((int)Math.round((double)numTileY * r), 1);
                numTileX = Math.max(Math.min(CommonExecutor.PARALLELISM / numTileY, numTileX), 1);
            }
        }
        this.yStride = numTileX;
        this.tasks = new Task[numTileX * numTileY];
        this.runningThreads = new AtomicInteger(this.tasks.length);
        int xmin = data.getMinX();
        int ymin = data.getMinY();
        int xmax = Math.addExact(xmin, width);
        int ymax = Math.addExact(ymin, height);
        int xinc = JDK18.ceilDiv((int)width, (int)numTileX);
        int yinc = JDK18.ceilDiv((int)height, (int)numTileY);
        Rectangle subArea = new Rectangle(Math.addExact(xinc, overlapX), Math.addExact(yinc, overlapY));
        int count = 0;
        this.iterators = new PixelIterator[this.tasks.length];
        subArea.y = ymin;
        while (subArea.y < ymax) {
            subArea.x = xmin;
            while (subArea.x < xmax) {
                this.iterators[count++] = iteratorFactory.setRegionOfInterest(subArea).create(data);
                subArea.x += xinc;
            }
            subArea.y += yinc;
        }
        assert (count == this.tasks.length);
    }

    public final Future<R> execute() {
        Future[] components = new Future[this.tasks.length];
        while (this.taskIndex < components.length) {
            Task task = this.createSubTask();
            components[this.taskIndex++] = CommonExecutor.instance().submit(task);
        }
        this.iterators = null;
        return CompoundFuture.create(components);
    }

    protected abstract Task createSubTask();

    protected abstract class Task
    implements Callable<R> {
        private final int index;
        protected final PixelIterator iterator;
        private ReentrantLock merging;

        protected Task() {
            this.index = TiledProcess.this.taskIndex;
            this.iterator = TiledProcess.this.iterators[this.index];
        }

        protected abstract void execute() throws Exception;

        protected abstract void merge(Task var1) throws Exception;

        protected abstract R result() throws Exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public final R call() throws Exception {
            Task[] tasks;
            block29: {
                this.execute();
                tasks = TiledProcess.this.tasks;
                int yStride = TiledProcess.this.yStride;
                int rowStart = this.index - this.index % yStride;
                assert (this.merging == null);
                this.merging = new ReentrantLock();
                this.merging.lock();
                try {
                    Task[] taskArray = tasks;
                    // MONITORENTER : tasks
                    assert (tasks[this.index] == null);
                    tasks[this.index] = this;
                    // MONITOREXIT : taskArray
                    int count = 0;
                    int side = 0;
                    while (true) {
                        boolean valid;
                        int i;
                        switch (side) {
                            default: {
                                if ((count & 3) == 0) break block29;
                                count = 0;
                                side = 0;
                            }
                            case 0: {
                                i = this.index - yStride;
                                valid = i >= 0;
                                break;
                            }
                            case 1: {
                                i = this.index - 1;
                                valid = i >= rowStart;
                                break;
                            }
                            case 2: {
                                i = this.index + 1;
                                valid = i < rowStart + yStride;
                                break;
                            }
                            case 3: {
                                i = this.index + yStride;
                                boolean bl = valid = i < tasks.length;
                            }
                        }
                        if (valid) {
                            Task[] taskArray2 = tasks;
                            // MONITORENTER : tasks
                            Task neighbor = tasks[i];
                            if (neighbor == null || neighbor == this || !neighbor.merging.tryLock()) {
                                // MONITOREXIT : taskArray2
                            } else {
                                for (int j = 0; j < tasks.length; ++j) {
                                    if (tasks[j] != neighbor) continue;
                                    tasks[j] = this;
                                }
                                // MONITOREXIT : taskArray2
                                try {
                                    this.merge(neighbor);
                                }
                                finally {
                                    neighbor.merging.unlock();
                                }
                                ++count;
                            }
                        }
                        ++side;
                    }
                }
                finally {
                    this.merging.unlock();
                }
            }
            if (TiledProcess.this.runningThreads.decrementAndGet() != 0) {
                return null;
            }
            int i = 0;
            while (i < tasks.length) {
                Task other = tasks[i];
                if (other != null && other != this) {
                    assert (!other.merging.isLocked());
                    for (int j = i; j < tasks.length; ++j) {
                        if (tasks[j] != other) continue;
                        tasks[j] = this;
                    }
                    this.merge(other);
                }
                ++i;
            }
            return this.result();
        }
    }
}

