/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.timer.rocksdb;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class TimerRocksDBRecord {
    private static final Logger logError = LoggerFactory.getLogger((String)"RocketmqStoreError");
    public static final byte TIMER_ROCKSDB_PUT = 0;
    public static final byte TIMER_ROCKSDB_DELETE = 1;
    public static final byte TIMER_ROCKSDB_UPDATE = 2;
    private static final int VALUE_LENGTH = 12;
    private long delayTime;
    private String uniqKey;
    private int sizePy;
    private long offsetPy;
    private long queueOffset;
    private long checkPoint;
    private byte actionFlag;
    private MessageExt messageExt;

    public TimerRocksDBRecord() {
    }

    public TimerRocksDBRecord(long delayTime, String uniqKey, long offsetPy, int sizePy, long queueOffset, MessageExt messageExt) {
        this.delayTime = delayTime;
        this.uniqKey = uniqKey;
        this.offsetPy = offsetPy;
        this.sizePy = sizePy;
        this.messageExt = messageExt;
        this.queueOffset = queueOffset;
    }

    public byte[] getKeyBytes() {
        if (StringUtils.isEmpty((CharSequence)this.uniqKey) || this.delayTime <= 0L) {
            return null;
        }
        try {
            byte[] uniqKeyBytes = this.uniqKey.getBytes(StandardCharsets.UTF_8);
            int keyLength = 8 + uniqKeyBytes.length;
            return ByteBuffer.allocate(keyLength).putLong(this.delayTime).put(uniqKeyBytes).array();
        }
        catch (Exception e) {
            logError.error("TimerRocksDBRecord getKeyBytes error: {}", (Object)e.getMessage());
            return null;
        }
    }

    public byte[] getValueBytes() {
        if (this.sizePy <= 0 || this.offsetPy < 0L) {
            return null;
        }
        try {
            return ByteBuffer.allocate(12).putInt(this.sizePy).putLong(this.offsetPy).array();
        }
        catch (Exception e) {
            logError.error("TimerRocksDBRecord getValueBytes error: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static TimerRocksDBRecord decode(byte[] key, byte[] value) {
        if (null == key || key.length < 8 || null == value || value.length != 12) {
            return null;
        }
        try {
            TimerRocksDBRecord rocksDBRecord = new TimerRocksDBRecord();
            ByteBuffer keyBuffer = ByteBuffer.wrap(key);
            rocksDBRecord.setDelayTime(keyBuffer.getLong());
            byte[] uniqKey = new byte[key.length - 8];
            keyBuffer.get(uniqKey);
            rocksDBRecord.setUniqKey(new String(uniqKey, StandardCharsets.UTF_8));
            ByteBuffer valueByteBuffer = ByteBuffer.wrap(value);
            rocksDBRecord.setSizePy(valueByteBuffer.getInt());
            rocksDBRecord.setOffsetPy(valueByteBuffer.getLong());
            return rocksDBRecord;
        }
        catch (Exception e) {
            logError.error("TimerRocksDBRecord decode error: {}", (Object)e.getMessage());
            return null;
        }
    }

    public void setDelayTime(long delayTime) {
        this.delayTime = delayTime;
    }

    public void setOffsetPy(long offsetPy) {
        this.offsetPy = offsetPy;
    }

    public void setSizePy(int sizePy) {
        this.sizePy = sizePy;
    }

    public int getSizePy() {
        return this.sizePy;
    }

    public long getDelayTime() {
        return this.delayTime;
    }

    public long getOffsetPy() {
        return this.offsetPy;
    }

    public MessageExt getMessageExt() {
        return this.messageExt;
    }

    public void setMessageExt(MessageExt messageExt) {
        this.messageExt = messageExt;
    }

    public String getUniqKey() {
        return this.uniqKey;
    }

    public void setUniqKey(String uniqKey) {
        this.uniqKey = uniqKey;
    }

    public void setCheckPoint(long checkPoint) {
        this.checkPoint = checkPoint;
    }

    public long getCheckPoint() {
        return this.checkPoint;
    }

    public long getQueueOffset() {
        return this.queueOffset;
    }

    public void setQueueOffset(long queueOffset) {
        this.queueOffset = queueOffset;
    }

    public byte getActionFlag() {
        return this.actionFlag;
    }

    public void setActionFlag(byte actionFlag) {
        this.actionFlag = actionFlag;
    }

    public String toString() {
        return "TimerRocksDBRecord{delayTime=" + this.delayTime + ", uniqKey=" + this.uniqKey + ", sizePy=" + this.sizePy + ", offsetPy=" + this.offsetPy + ", queueOffset=" + this.queueOffset + ", checkPoint=" + this.checkPoint + '}';
    }
}

