/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.manager.AbstractAuthenticationManager;
import org.apache.qpid.server.security.auth.manager.SpnegoAuthenticator;
import org.apache.qpid.server.security.auth.sasl.SaslNegotiator;
import org.apache.qpid.server.security.auth.sasl.SaslSettings;
import org.apache.qpid.server.security.auth.sasl.kerberos.KerberosNegotiator;

@ManagedObject(category=false, type="Kerberos")
public class KerberosAuthenticationManager
extends AbstractAuthenticationManager<KerberosAuthenticationManager> {
    private static final String JAAS_CONFIG_PROPERTY = "java.security.auth.login.config";
    private static final String GSSAPI_SERVER_NAME = "qpid.auth.gssapi.serverName";
    private static final String GSSAPI_SPNEGO_STRIP_REALM = "qpid.auth.gssapi.spnegoStripRealmFromPrincipalName";
    static final String GSSAPI_SPNEGO_CONFIG = "qpid.auth.gssapi.spnegoConfigScope";
    public static final String PROVIDER_TYPE = "Kerberos";
    public static final String GSSAPI_MECHANISM = "GSSAPI";
    private final Container<?> _container;
    private final SpnegoAuthenticator _authenticator;
    private volatile String _serverName;
    private volatile String _spnegoConfig;
    private volatile boolean _stripRealmFromPrincipalName;

    @ManagedObjectFactoryConstructor
    protected KerberosAuthenticationManager(Map<String, Object> attributes, Container<?> container) {
        super(attributes, container);
        this._container = container;
        this._authenticator = new SpnegoAuthenticator(this);
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        Set<String> contextKeys = this.getContextKeys(false);
        this._serverName = contextKeys.contains(GSSAPI_SERVER_NAME) ? this.getContextValue(String.class, GSSAPI_SERVER_NAME) : null;
        this._spnegoConfig = contextKeys.contains(GSSAPI_SPNEGO_CONFIG) ? this.getContextValue(String.class, GSSAPI_SPNEGO_CONFIG) : null;
        this._stripRealmFromPrincipalName = contextKeys.contains(GSSAPI_SPNEGO_STRIP_REALM) ? this.getContextValue(Boolean.class, GSSAPI_SPNEGO_STRIP_REALM) : false;
    }

    @Override
    public List<String> getMechanisms() {
        return Collections.singletonList(GSSAPI_MECHANISM);
    }

    @Override
    public SaslNegotiator createSaslNegotiator(String mechanism, SaslSettings saslSettings, NamedAddressSpace addressSpace) {
        if (GSSAPI_MECHANISM.equals(mechanism)) {
            String serverName = this._serverName == null ? saslSettings.getLocalFQDN() : this._serverName;
            return new KerberosNegotiator(this, serverName);
        }
        return null;
    }

    public AuthenticationResult authenticate(String authorizationHeader) {
        return this._authenticator.authenticate(authorizationHeader);
    }

    public String getSpnegoLoginConfigScope() {
        return this._spnegoConfig;
    }

    public boolean isStripRealmFromPrincipalName() {
        return this._stripRealmFromPrincipalName;
    }

    @Override
    protected void validateOnCreate() {
        super.validateOnCreate();
        this.validate(this);
        if (this._container.getChildren(AuthenticationProvider.class).stream().anyMatch(p -> p instanceof KerberosAuthenticationManager && p != this)) {
            throw new IllegalConfigurationException("Another Kerberos authentication provider already exists. Only one Kerberos authentication provider can be created.");
        }
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
    }

    private void validate(ConfiguredObject<?> authenticationProvider) {
        String config = System.getProperty(JAAS_CONFIG_PROPERTY);
        if (config != null && !new File(config).exists()) {
            throw new IllegalConfigurationException(String.format("A path to non-existing file is specified in JVM system property '%s'", JAAS_CONFIG_PROPERTY));
        }
    }
}

