/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.extension.auth.opa;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.apache.polaris.extension.auth.opa.OpaAuthorizationConfig;
import org.immutables.value.Generated;

@Generated(from="OpaAuthorizationConfig.BearerTokenConfig.FileBasedConfig", generator="Immutables")
public final class ImmutableFileBasedConfig
implements OpaAuthorizationConfig.BearerTokenConfig.FileBasedConfig {
    private final Path path;
    private final Duration refreshInterval;
    private final Boolean jwtExpirationRefresh;
    private final Duration jwtExpirationBuffer;
    private transient int hashCode;

    private ImmutableFileBasedConfig(Path path, Duration refreshInterval, Boolean jwtExpirationRefresh, Duration jwtExpirationBuffer) {
        this.path = path;
        this.refreshInterval = refreshInterval;
        this.jwtExpirationRefresh = jwtExpirationRefresh;
        this.jwtExpirationBuffer = jwtExpirationBuffer;
    }

    @Override
    public Path path() {
        return this.path;
    }

    @Override
    public Optional<Duration> refreshInterval() {
        return Optional.ofNullable(this.refreshInterval);
    }

    @Override
    public Optional<Boolean> jwtExpirationRefresh() {
        return Optional.ofNullable(this.jwtExpirationRefresh);
    }

    @Override
    public Optional<Duration> jwtExpirationBuffer() {
        return Optional.ofNullable(this.jwtExpirationBuffer);
    }

    public final ImmutableFileBasedConfig withPath(Path value) {
        if (this.path == value) {
            return this;
        }
        Path newValue = Objects.requireNonNull(value, "path");
        return new ImmutableFileBasedConfig(newValue, this.refreshInterval, this.jwtExpirationRefresh, this.jwtExpirationBuffer);
    }

    public final ImmutableFileBasedConfig withRefreshInterval(Duration value) {
        Duration newValue = Objects.requireNonNull(value, "refreshInterval");
        if (this.refreshInterval == newValue) {
            return this;
        }
        return new ImmutableFileBasedConfig(this.path, newValue, this.jwtExpirationRefresh, this.jwtExpirationBuffer);
    }

    public final ImmutableFileBasedConfig withRefreshInterval(Optional<? extends Duration> optional) {
        Duration value = optional.orElse(null);
        if (this.refreshInterval == value) {
            return this;
        }
        return new ImmutableFileBasedConfig(this.path, value, this.jwtExpirationRefresh, this.jwtExpirationBuffer);
    }

    public final ImmutableFileBasedConfig withJwtExpirationRefresh(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.jwtExpirationRefresh, newValue)) {
            return this;
        }
        return new ImmutableFileBasedConfig(this.path, this.refreshInterval, newValue, this.jwtExpirationBuffer);
    }

    public final ImmutableFileBasedConfig withJwtExpirationRefresh(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.jwtExpirationRefresh, value)) {
            return this;
        }
        return new ImmutableFileBasedConfig(this.path, this.refreshInterval, value, this.jwtExpirationBuffer);
    }

    public final ImmutableFileBasedConfig withJwtExpirationBuffer(Duration value) {
        Duration newValue = Objects.requireNonNull(value, "jwtExpirationBuffer");
        if (this.jwtExpirationBuffer == newValue) {
            return this;
        }
        return new ImmutableFileBasedConfig(this.path, this.refreshInterval, this.jwtExpirationRefresh, newValue);
    }

    public final ImmutableFileBasedConfig withJwtExpirationBuffer(Optional<? extends Duration> optional) {
        Duration value = optional.orElse(null);
        if (this.jwtExpirationBuffer == value) {
            return this;
        }
        return new ImmutableFileBasedConfig(this.path, this.refreshInterval, this.jwtExpirationRefresh, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFileBasedConfig && this.equalsByValue((ImmutableFileBasedConfig)another);
    }

    private boolean equalsByValue(ImmutableFileBasedConfig another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.path.equals(another.path) && Objects.equals(this.refreshInterval, another.refreshInterval) && Objects.equals(this.jwtExpirationRefresh, another.jwtExpirationRefresh) && Objects.equals(this.jwtExpirationBuffer, another.jwtExpirationBuffer);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + Objects.hashCode(this.refreshInterval);
        h += (h << 5) + Objects.hashCode(this.jwtExpirationRefresh);
        h += (h << 5) + Objects.hashCode(this.jwtExpirationBuffer);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FileBasedConfig").omitNullValues().add("path", (Object)this.path).add("refreshInterval", (Object)this.refreshInterval).add("jwtExpirationRefresh", (Object)this.jwtExpirationRefresh).add("jwtExpirationBuffer", (Object)this.jwtExpirationBuffer).toString();
    }

    public static ImmutableFileBasedConfig copyOf(OpaAuthorizationConfig.BearerTokenConfig.FileBasedConfig instance) {
        if (instance instanceof ImmutableFileBasedConfig) {
            return (ImmutableFileBasedConfig)instance;
        }
        return ImmutableFileBasedConfig.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableFileBasedConfig.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OpaAuthorizationConfig.BearerTokenConfig.FileBasedConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PATH = 1L;
        private long initBits = 1L;
        private Path path;
        private Duration refreshInterval;
        private Boolean jwtExpirationRefresh;
        private Duration jwtExpirationBuffer;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(OpaAuthorizationConfig.BearerTokenConfig.FileBasedConfig instance) {
            Optional<Duration> jwtExpirationBufferOptional;
            Optional<Boolean> jwtExpirationRefreshOptional;
            Objects.requireNonNull(instance, "instance");
            this.path(instance.path());
            Optional<Duration> refreshIntervalOptional = instance.refreshInterval();
            if (refreshIntervalOptional.isPresent()) {
                this.refreshInterval(refreshIntervalOptional);
            }
            if ((jwtExpirationRefreshOptional = instance.jwtExpirationRefresh()).isPresent()) {
                this.jwtExpirationRefresh(jwtExpirationRefreshOptional);
            }
            if ((jwtExpirationBufferOptional = instance.jwtExpirationBuffer()).isPresent()) {
                this.jwtExpirationBuffer(jwtExpirationBufferOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder path(Path path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refreshInterval(Duration refreshInterval) {
            this.refreshInterval = Objects.requireNonNull(refreshInterval, "refreshInterval");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refreshInterval(Optional<? extends Duration> refreshInterval) {
            this.refreshInterval = refreshInterval.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder jwtExpirationRefresh(boolean jwtExpirationRefresh) {
            this.jwtExpirationRefresh = jwtExpirationRefresh;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder jwtExpirationRefresh(Optional<Boolean> jwtExpirationRefresh) {
            this.jwtExpirationRefresh = jwtExpirationRefresh.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder jwtExpirationBuffer(Duration jwtExpirationBuffer) {
            this.jwtExpirationBuffer = Objects.requireNonNull(jwtExpirationBuffer, "jwtExpirationBuffer");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder jwtExpirationBuffer(Optional<? extends Duration> jwtExpirationBuffer) {
            this.jwtExpirationBuffer = jwtExpirationBuffer.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 1L;
            this.path = null;
            this.refreshInterval = null;
            this.jwtExpirationRefresh = null;
            this.jwtExpirationBuffer = null;
            return this;
        }

        public ImmutableFileBasedConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFileBasedConfig(this.path, this.refreshInterval, this.jwtExpirationRefresh, this.jwtExpirationBuffer);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("path");
            }
            return "Cannot build FileBasedConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

