/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.taglibs.standard.lang.jstl;

import org.glassfish.wasp.taglibs.standard.lang.jstl.BinaryOperator;
import org.glassfish.wasp.taglibs.standard.lang.jstl.Coercions;
import org.glassfish.wasp.taglibs.standard.lang.jstl.Constants;
import org.glassfish.wasp.taglibs.standard.lang.jstl.ELException;
import org.glassfish.wasp.taglibs.standard.lang.jstl.Logger;
import org.glassfish.wasp.taglibs.standard.lang.jstl.PrimitiveObjects;

public class DivideOperator
extends BinaryOperator {
    public static final DivideOperator SINGLETON = new DivideOperator();

    @Override
    public String getOperatorSymbol() {
        return "/";
    }

    @Override
    public Object apply(Object pLeft, Object pRight, Object pContext, Logger pLogger) throws ELException {
        if (pLeft == null && pRight == null) {
            if (pLogger.isLoggingWarning()) {
                pLogger.logWarning(Constants.ARITH_OP_NULL, this.getOperatorSymbol());
            }
            return PrimitiveObjects.getInteger(0);
        }
        double left = Coercions.coerceToPrimitiveNumber(pLeft, Double.class, pLogger).doubleValue();
        double right = Coercions.coerceToPrimitiveNumber(pRight, Double.class, pLogger).doubleValue();
        try {
            return PrimitiveObjects.getDouble(left / right);
        }
        catch (Exception exc) {
            if (pLogger.isLoggingError()) {
                pLogger.logError(Constants.ARITH_ERROR, this.getOperatorSymbol(), (Object)("" + left), (Object)("" + right));
            }
            return PrimitiveObjects.getInteger(0);
        }
    }
}

