/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Date;
import org.apache.nifi.web.api.dto.util.TimestampAdapter;

public abstract class FlowUpdateRequestDTO {
    protected String requestId;
    protected String processGroupId;
    protected String uri;
    protected Date lastUpdated;
    protected boolean complete = false;
    protected String failureReason;
    protected int percentCompleted;
    protected String state;

    @Schema(description="The unique ID of the Process Group being updated")
    public String getProcessGroupId() {
        return this.processGroupId;
    }

    public void setProcessGroupId(String processGroupId) {
        this.processGroupId = processGroupId;
    }

    @Schema(description="The unique ID of this request.", accessMode=Schema.AccessMode.READ_ONLY)
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    @Schema(description="The URI for future requests to this drop request.", accessMode=Schema.AccessMode.READ_ONLY)
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @XmlJavaTypeAdapter(value=TimestampAdapter.class)
    @Schema(description="The last time this request was updated.", type="string", accessMode=Schema.AccessMode.READ_ONLY)
    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    @Schema(description="Whether or not this request has completed", accessMode=Schema.AccessMode.READ_ONLY)
    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    @Schema(description="An explanation of why this request failed, or null if this request has not failed", accessMode=Schema.AccessMode.READ_ONLY)
    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String reason) {
        this.failureReason = reason;
    }

    @Schema(description="The state of the request", accessMode=Schema.AccessMode.READ_ONLY)
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Schema(description="The percentage complete for the request, between 0 and 100", accessMode=Schema.AccessMode.READ_ONLY)
    public int getPercentCompleted() {
        return this.percentCompleted;
    }

    public void setPercentCompleted(int percentCompleted) {
        this.percentCompleted = percentCompleted;
    }
}

