/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.params;

import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.ParamProviderClient;
import org.apache.nifi.web.api.dto.ParameterProviderDTO;
import org.apache.nifi.web.api.entity.ParameterProviderEntity;

public class SetParamProviderProperty
extends AbstractNiFiCommand<StringResult> {
    public SetParamProviderProperty() {
        super("set-param-provider-property", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Sets a property on a parameter provider.";
    }

    @Override
    protected void doInitialize(Context context) {
        super.doInitialize(context);
        this.addOption(CommandOption.PARAM_PROVIDER_ID.createOption());
        this.addOption(CommandOption.PROPERTY_NAME.createOption());
        this.addOption(CommandOption.PROPERTY_VALUE.createOption());
    }

    @Override
    public StringResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String paramProviderId = this.getRequiredArg(properties, CommandOption.PARAM_PROVIDER_ID);
        String propertyName = this.getRequiredArg(properties, CommandOption.PROPERTY_NAME);
        String propertyValue = this.getArg(properties, CommandOption.PROPERTY_VALUE);
        ParamProviderClient paramProviderClient = client.getParamProviderClient();
        ParameterProviderEntity existingParameterProvider = paramProviderClient.getParamProvider(paramProviderId);
        ParameterProviderDTO existingParameterProviderDTO = existingParameterProvider.getComponent();
        ParameterProviderDTO paramProviderDTO = new ParameterProviderDTO();
        paramProviderDTO.setId(paramProviderId);
        paramProviderDTO.setName(existingParameterProviderDTO.getName());
        paramProviderDTO.setType(existingParameterProviderDTO.getType());
        paramProviderDTO.setAnnotationData(existingParameterProviderDTO.getAnnotationData());
        paramProviderDTO.setComments(existingParameterProviderDTO.getComments());
        paramProviderDTO.setBundle(existingParameterProviderDTO.getBundle());
        HashMap<String, String> updatedProperties = new HashMap<String, String>();
        if (existingParameterProviderDTO.getProperties() != null) {
            updatedProperties.putAll(existingParameterProviderDTO.getProperties());
        }
        updatedProperties.put(propertyName, propertyValue);
        paramProviderDTO.setProperties(updatedProperties);
        ParameterProviderEntity paramProviderEntity = new ParameterProviderEntity();
        paramProviderEntity.setComponent(paramProviderDTO);
        paramProviderEntity.setId(paramProviderId);
        paramProviderEntity.setRevision(existingParameterProvider.getRevision());
        ParameterProviderEntity updatedParameterProvider = paramProviderClient.updateParamProvider(paramProviderEntity);
        return new StringResult(updatedParameterProvider.getId(), this.isInteractive());
    }
}

