/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.validation.event;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class ImmutableLazySetCopy<T> {
    private final Set<T> original;
    private final AtomicReference<Set<T>> copy = new AtomicReference();

    ImmutableLazySetCopy(Set<T> original) {
        this.original = original;
    }

    public Set<T> get() {
        return this.copy.updateAndGet(existingCopy -> existingCopy == null ? Set.copyOf(this.original) : existingCopy);
    }

    public String toString() {
        return Optional.ofNullable(this.copy.get()).orElse(this.original).toString();
    }
}

