/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdflink;

import java.net.Authenticator;
import java.net.http.HttpClient;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.http.HttpEnv;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdfconnection.Isolation;
import org.apache.jena.rdfconnection.JenaConnectionException;
import org.apache.jena.rdfconnection.LibSec;
import org.apache.jena.rdflink.LinkDatasetGraph;
import org.apache.jena.rdflink.LinkSparqlQuery;
import org.apache.jena.rdflink.LinkSparqlUpdate;
import org.apache.jena.rdflink.RDFLinkDatasetBuilder;
import org.apache.jena.rdflink.RDFLinkHTTP;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.UpdateExecBuilder;
import org.apache.jena.system.Txn;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

public interface RDFLink
extends LinkSparqlQuery,
LinkSparqlUpdate,
LinkDatasetGraph,
Transactional,
AutoCloseable {
    public static RDFLink connect(DatasetGraph dataset) {
        return RDFLinkDatasetBuilder.newBuilder().dataset(dataset).build();
    }

    public static RDFLink connect(DatasetGraph dataset, Isolation isolation) {
        return RDFLinkDatasetBuilder.newBuilder().dataset(dataset).isolation(isolation).build();
    }

    public static RDFLink queryConnect(String queryServiceURL) {
        return RDFLinkHTTP.newBuilder().queryEndpoint(queryServiceURL).queryOnly().build();
    }

    public static RDFLink connect(String serviceURL) {
        return RDFLinkHTTP.service(serviceURL).build();
    }

    public static RDFLink connectPW(String URL2, String user, String password) {
        Objects.requireNonNull(URL2);
        Objects.requireNonNull(user);
        Objects.requireNonNull(password);
        Authenticator authenticator = LibSec.authenticator(user, password);
        HttpClient client = HttpEnv.httpClientBuilder().authenticator(authenticator).build();
        return RDFLinkHTTP.newBuilder().destination(URL2).httpClient(client).build();
    }

    @Override
    default public void queryRowSet(String queryString, Consumer<RowSet> rowSetAction) {
        Txn.executeRead((Transactional)this, () -> {
            try (QueryExec qExec = this.query(queryString);){
                RowSet rs = qExec.select();
                rowSetAction.accept(rs);
            }
        });
    }

    @Override
    default public void queryRowSet(Query query, Consumer<RowSet> rowSetAction) {
        if (!query.isSelectType()) {
            throw new JenaConnectionException("Query is not a SELECT query");
        }
        Txn.executeRead((Transactional)this, () -> {
            try (QueryExec qExec = this.query(query);){
                RowSet rs = qExec.select();
                rowSetAction.accept(rs);
            }
        });
    }

    private static void forEachRow(RowSet rowSet, Consumer<Binding> rowAction) {
        rowSet.forEachRemaining(rowAction);
    }

    @Override
    default public void querySelect(String queryString, Consumer<Binding> rowAction) {
        Txn.executeRead((Transactional)this, () -> {
            try (QueryExec qExec = this.query(queryString);){
                RDFLink.forEachRow(qExec.select(), rowAction);
            }
        });
    }

    @Override
    default public void querySelect(Query query, Consumer<Binding> rowAction) {
        if (!query.isSelectType()) {
            throw new JenaConnectionException("Query is not a SELECT query");
        }
        Txn.executeRead((Transactional)this, () -> {
            try (QueryExec qExec = this.query(query);){
                RDFLink.forEachRow(qExec.select(), rowAction);
            }
        });
    }

    @Override
    default public Graph queryConstruct(String queryString) {
        return (Graph)Txn.calculateRead((Transactional)this, () -> {
            try (QueryExec qExec = this.query(queryString);){
                Graph graph = qExec.construct();
                return graph;
            }
        });
    }

    default public DatasetGraph queryConstructDataset(Query query) {
        return (DatasetGraph)Txn.calculateRead((Transactional)this, () -> {
            try (QueryExec qExec = this.query(query);){
                DatasetGraph datasetGraph = qExec.constructDataset();
                return datasetGraph;
            }
        });
    }

    default public DatasetGraph queryConstructDataset(String queryString) {
        return (DatasetGraph)Txn.calculateRead((Transactional)this, () -> {
            try (QueryExec qExec = this.query(queryString);){
                DatasetGraph datasetGraph = qExec.constructDataset();
                return datasetGraph;
            }
        });
    }

    @Override
    default public Graph queryConstruct(Query query) {
        return (Graph)Txn.calculateRead((Transactional)this, () -> {
            try (QueryExec qExec = this.query(query);){
                Graph graph = qExec.construct();
                return graph;
            }
        });
    }

    @Override
    default public Graph queryDescribe(String queryString) {
        return (Graph)Txn.calculateRead((Transactional)this, () -> {
            try (QueryExec qExec = this.query(queryString);){
                Graph graph = qExec.describe();
                return graph;
            }
        });
    }

    @Override
    default public Graph queryDescribe(Query query) {
        return (Graph)Txn.calculateRead((Transactional)this, () -> {
            try (QueryExec qExec = this.query(query);){
                Graph graph = qExec.describe();
                return graph;
            }
        });
    }

    @Override
    default public boolean queryAsk(String queryString) {
        return (Boolean)Txn.calculateRead((Transactional)this, () -> {
            try (QueryExec qExec = this.query(queryString);){
                Boolean bl = qExec.ask();
                return bl;
            }
        });
    }

    @Override
    default public boolean queryAsk(Query query) {
        return (Boolean)Txn.calculateRead((Transactional)this, () -> {
            try (QueryExec qExec = this.query(query);){
                Boolean bl = qExec.ask();
                return bl;
            }
        });
    }

    @Override
    public QueryExec query(Query var1);

    @Override
    default public QueryExec query(String queryString) {
        return this.query(QueryFactory.create((String)queryString));
    }

    @Override
    public QueryExecBuilder newQuery();

    @Override
    public UpdateExecBuilder newUpdate();

    @Override
    default public void update(Update update) {
        this.update(new UpdateRequest(update));
    }

    @Override
    public void update(UpdateRequest var1);

    @Override
    default public void update(String updateString) {
        this.update(UpdateFactory.create((String)updateString));
    }

    @Override
    public Graph get();

    @Override
    default public Graph get(String graphName) {
        Node gn = NodeFactory.createURI((String)graphName);
        return this.get(gn);
    }

    @Override
    public Graph get(Node var1);

    @Override
    public void load(String var1);

    @Override
    public void load(Node var1, String var2);

    @Override
    public void load(Graph var1);

    @Override
    public void load(Node var1, Graph var2);

    @Override
    public void put(String var1);

    @Override
    public void put(Node var1, String var2);

    @Override
    public void put(Graph var1);

    @Override
    public void put(Node var1, Graph var2);

    @Override
    public void delete(Node var1);

    @Override
    public void delete();

    @Override
    public void loadDataset(String var1);

    @Override
    public void loadDataset(DatasetGraph var1);

    @Override
    public void putDataset(String var1);

    @Override
    public void putDataset(DatasetGraph var1);

    @Override
    public void clearDataset();

    @Override
    public boolean isClosed();

    default public boolean isRemote() {
        return false;
    }

    @Override
    public void close();
}

