/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dmatch;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.library.dmatch.util.CrossCorrelation;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFXCorr
implements UDTF {
    private final List<Double> valueArrayList0 = new ArrayList<Double>();
    private final List<Double> valueArrayList1 = new ArrayList<Double>();

    @Override
    public void beforeStart(UDFParameters udfParameters, UDTFConfigurations udtfConfigurations) throws Exception {
        udtfConfigurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
        this.valueArrayList0.clear();
        this.valueArrayList1.clear();
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        if (row.isNull(0) || row.isNull(1)) {
            this.valueArrayList0.add(Double.NaN);
            this.valueArrayList1.add(Double.NaN);
        } else {
            this.valueArrayList0.add(Util.getValueAsDouble(row, 0));
            this.valueArrayList1.add(Util.getValueAsDouble(row, 1));
        }
    }

    @Override
    public void terminate(PointCollector collector) throws Exception {
        List<Double> correlationArrayList = CrossCorrelation.calculateCrossCorrelation(this.valueArrayList0, this.valueArrayList1);
        for (int i = 0; i < correlationArrayList.size(); ++i) {
            collector.putDouble(i, correlationArrayList.get(i));
        }
    }

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(2).validateInputSeriesDataType(0, Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE).validateInputSeriesDataType(1, Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE);
    }

    @Override
    public void beforeDestroy() {
        this.valueArrayList0.clear();
        this.valueArrayList1.clear();
    }
}

