/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.db.exception.mpp.FragmentInstanceFetchException;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.execution.QueryExecution;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.statistics.FragmentInstanceStatisticsDrawer;
import org.apache.iotdb.db.queryengine.statistics.QueryStatisticsFetcher;
import org.apache.iotdb.db.queryengine.statistics.StatisticLine;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.mpp.rpc.thrift.TFetchFragmentInstanceStatisticsResp;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplainAnalyzeOperator
implements ProcessOperator {
    private static final Logger logger = LoggerFactory.getLogger((String)"EXPLAIN_ANALYZE");
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(ExplainAnalyzeOperator.class);
    private static final String LOG_TITLE = "---------------------Intermediate Results of EXPLAIN ANALYZE---------------------:";
    private final OperatorContext operatorContext;
    private final Operator child;
    private final boolean verbose;
    private boolean outputResult = false;
    private final List<FragmentInstance> instances;
    private final FragmentInstanceStatisticsDrawer fragmentInstanceStatisticsDrawer = new FragmentInstanceStatisticsDrawer();
    private final ScheduledFuture<?> logRecordTask;
    private final IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> clientManager;
    private final MPPQueryContext mppQueryContext;

    public ExplainAnalyzeOperator(OperatorContext operatorContext, Operator child, long queryId, boolean verbose, long timeout) {
        this.operatorContext = operatorContext;
        this.child = child;
        this.verbose = verbose;
        Coordinator coordinator = Coordinator.getInstance();
        this.clientManager = coordinator.getInternalServiceClientManager();
        QueryExecution queryExecution = (QueryExecution)coordinator.getQueryExecution(queryId);
        this.instances = queryExecution.getDistributedPlan().getInstances();
        this.mppQueryContext = queryExecution.getContext();
        this.fragmentInstanceStatisticsDrawer.renderPlanStatistics(this.mppQueryContext);
        long logIntervalInMs = Math.min(timeout / 3L, 15000L);
        this.logRecordTask = ScheduledExecutorUtil.safelyScheduleAtFixedRate((ScheduledExecutorService)queryExecution.getScheduledExecutor(), this::logIntermediateResultIfTimeout, (long)logIntervalInMs, (long)logIntervalInMs, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() throws Exception {
        if (this.child.hasNextWithTimer()) {
            this.child.nextWithTimer();
            return null;
        }
        this.fragmentInstanceStatisticsDrawer.renderDispatchCost(this.mppQueryContext);
        TsBlock result = this.buildResult();
        this.outputResult = true;
        return result;
    }

    private List<String> buildFragmentInstanceStatistics(List<FragmentInstance> instances, boolean verbose) throws FragmentInstanceFetchException {
        Map<FragmentInstanceId, TFetchFragmentInstanceStatisticsResp> allStatistics = QueryStatisticsFetcher.fetchAllStatistics(instances, this.clientManager);
        List<StatisticLine> statisticLines = this.fragmentInstanceStatisticsDrawer.renderFragmentInstances(instances, allStatistics, verbose);
        ArrayList<String> analyzeResult = new ArrayList<String>();
        for (StatisticLine line : statisticLines) {
            StringBuilder sb = new StringBuilder();
            sb.append(line.getValue());
            for (int i = 0; i < this.fragmentInstanceStatisticsDrawer.getMaxLineLength() - line.getValue().length(); ++i) {
                sb.append(" ");
            }
            analyzeResult.add(sb.toString());
        }
        return analyzeResult;
    }

    private void logIntermediateResultIfTimeout() {
        try (SetThreadName ignored = new SetThreadName(String.format("%s-Explain-Analyze-Logger", this.operatorContext.getInstanceContext().getId().getQueryId()));){
            List<String> analyzeResult = this.buildFragmentInstanceStatistics(this.instances, this.verbose);
            StringBuilder logContent = new StringBuilder();
            logContent.append("\n").append(LOG_TITLE).append("\n");
            for (String line : analyzeResult) {
                logContent.append(line).append("\n");
            }
            String res = logContent.toString();
            logger.info(res);
        }
        catch (Exception e) {
            logger.error("Error occurred when logging intermediate result of analyze.", (Throwable)e);
        }
    }

    private TsBlock buildResult() throws FragmentInstanceFetchException {
        List<String> analyzeResult = this.buildFragmentInstanceStatistics(this.instances, this.verbose);
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(TSDataType.TEXT));
        TimeColumnBuilder timeColumnBuilder = builder.getTimeColumnBuilder();
        ColumnBuilder columnBuilder = builder.getColumnBuilder(0);
        for (String line : analyzeResult) {
            timeColumnBuilder.writeLong(0L);
            columnBuilder.writeBinary(new Binary(line.getBytes()));
            builder.declarePosition();
        }
        return builder.build();
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.child.hasNext() || !this.outputResult;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
        if (this.logRecordTask != null) {
            boolean cancelResult = this.logRecordTask.cancel(true);
            if (!cancelResult) {
                logger.debug("cancel state tracking task failed. {}", (Object)this.logRecordTask.isCancelled());
            }
        } else {
            logger.debug("trackTask not started");
        }
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.child.hasNext() && this.outputResult;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return 0L;
    }

    @Override
    public long calculateMaxReturnSize() {
        return 0L;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return 0L;
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.child) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext);
    }
}

