/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.worker;

import com.google.common.util.concurrent.MoreExecutors;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.basehookloader.BaseHookLoader;
import org.apache.bifromq.basekv.balance.KVStoreBalanceController;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basekv.server.IBaseKVStoreServer;
import org.apache.bifromq.basekv.store.api.IKVRangeCoProcFactory;
import org.apache.bifromq.baserpc.client.IConnectable;
import org.apache.bifromq.deliverer.BatchDeliveryCallBuilderFactory;
import org.apache.bifromq.deliverer.IMessageDeliverer;
import org.apache.bifromq.deliverer.MessageDeliverer;
import org.apache.bifromq.dist.worker.DistWorkerBuilder;
import org.apache.bifromq.dist.worker.DistWorkerCleaner;
import org.apache.bifromq.dist.worker.DistWorkerCoProcFactory;
import org.apache.bifromq.dist.worker.IDistWorker;
import org.apache.bifromq.dist.worker.spi.IDistWorkerBalancerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DistWorker
implements IDistWorker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DistWorker.class);
    private final String clusterId;
    private final ExecutorService rpcExecutor;
    private final IBaseKVStoreClient distWorkerClient;
    private final IBaseKVStoreServer distWorkerServer;
    private final IMessageDeliverer messageDeliverer;
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.INIT);
    private final KVStoreBalanceController storeBalanceController;
    private final List<IDistWorkerBalancerFactory> effectiveBalancerFactories = new LinkedList<IDistWorkerBalancerFactory>();
    private final DistWorkerCoProcFactory coProcFactory;
    private final boolean jobExecutorOwner;
    private final ScheduledExecutorService jobScheduler;
    private final DistWorkerCleaner cleaner;

    public DistWorker(DistWorkerBuilder builder) {
        this.clusterId = builder.clusterId;
        this.messageDeliverer = new MessageDeliverer(new BatchDeliveryCallBuilderFactory(builder.distClient, builder.subBrokerManager));
        this.coProcFactory = new DistWorkerCoProcFactory(builder.distClient, builder.eventCollector, builder.resourceThrottler, builder.subBrokerManager, this.messageDeliverer, builder.settingProvider, builder.fanoutParallelism, builder.inlineFanoutThreshold);
        Map loadedFactories = BaseHookLoader.load(IDistWorkerBalancerFactory.class);
        for (String factoryName : builder.balancerFactoryConfig.keySet()) {
            if (!loadedFactories.containsKey(factoryName)) {
                log.warn("DistWorkerBalancerFactory[{}] not found", (Object)factoryName);
                continue;
            }
            IDistWorkerBalancerFactory balancer = (IDistWorkerBalancerFactory)loadedFactories.get(factoryName);
            balancer.init(builder.balancerFactoryConfig.get(factoryName));
            log.info("DistWorkerBalancerFactory[{}] enabled", (Object)factoryName);
            this.effectiveBalancerFactories.add(balancer);
        }
        this.storeBalanceController = new KVStoreBalanceController(builder.metaService, builder.distWorkerClient, this.effectiveBalancerFactories, builder.bootstrapDelay, builder.zombieProbeDelay, builder.balancerRetryDelay, builder.bgTaskExecutor);
        boolean bl = this.jobExecutorOwner = builder.bgTaskExecutor == null;
        if (this.jobExecutorOwner) {
            String threadName = String.format("dist-worker[%s]-job-executor", builder.clusterId);
            this.jobScheduler = ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ScheduledExecutorService)new ScheduledThreadPoolExecutor(1, EnvProvider.INSTANCE.newThreadFactory(threadName)), (String)threadName, (Tag[])new Tag[0]);
        } else {
            this.jobScheduler = builder.bgTaskExecutor;
        }
        this.rpcExecutor = builder.workerThreads == 0 ? MoreExecutors.newDirectExecutorService() : ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ExecutorService)new ThreadPoolExecutor(builder.workerThreads, builder.workerThreads, 0L, TimeUnit.MILLISECONDS, new LinkedTransferQueue<Runnable>(), EnvProvider.INSTANCE.newThreadFactory("dist-worker-executor")), (String)"dist-worker-executor", (Tag[])new Tag[0]);
        this.distWorkerClient = builder.distWorkerClient;
        this.distWorkerServer = IBaseKVStoreServer.builder().rpcServerBuilder(builder.rpcServerBuilder).metaService(builder.metaService).addService(builder.clusterId).coProcFactory((IKVRangeCoProcFactory)this.coProcFactory).storeOptions(builder.storeOptions).agentHost(builder.agentHost).queryExecutor(MoreExecutors.directExecutor()).rpcExecutor((Executor)this.rpcExecutor).tickerThreads(builder.tickerThreads).bgTaskExecutor(builder.bgTaskExecutor).attributes(builder.attributes).finish().build();
        this.cleaner = new DistWorkerCleaner(this.distWorkerClient, builder.minGCInterval, builder.maxGCInterval, this.jobScheduler);
        this.start();
    }

    @Override
    public String id() {
        return this.distWorkerServer.storeId(this.clusterId);
    }

    private void start() {
        if (this.status.compareAndSet(Status.INIT, Status.STARTING)) {
            log.info("Starting dist worker");
            this.distWorkerServer.start();
            String storeId = this.distWorkerServer.storeId(this.clusterId);
            this.storeBalanceController.start(storeId);
            this.status.compareAndSet(Status.STARTING, Status.STARTED);
            this.distWorkerClient.connState().filter(connState -> connState == IConnectable.ConnState.READY).takeUntil(connState -> connState == IConnectable.ConnState.READY).doOnComplete(() -> this.cleaner.start(storeId)).subscribe();
            log.debug("Dist worker started");
        }
    }

    @Override
    public void close() {
        if (this.status.compareAndSet(Status.STARTED, Status.STOPPING)) {
            log.info("Stopping DistWorker");
            this.cleaner.stop().join();
            this.storeBalanceController.stop();
            this.distWorkerServer.stop();
            log.debug("Stopping CoProcFactory");
            this.coProcFactory.close();
            this.effectiveBalancerFactories.forEach(IDistWorkerBalancerFactory::close);
            log.debug("Closing message deliverer");
            this.messageDeliverer.close();
            MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.rpcExecutor, (long)5L, (TimeUnit)TimeUnit.SECONDS);
            if (this.jobExecutorOwner) {
                log.debug("Shutting down job executor");
                MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.jobScheduler, (long)5L, (TimeUnit)TimeUnit.SECONDS);
            }
            log.debug("DistWorker stopped");
            this.status.compareAndSet(Status.STOPPING, Status.STOPPED);
        }
    }

    private static enum Status {
        INIT,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

