/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.memory;

import com.google.protobuf.ByteString;
import com.google.protobuf.Struct;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.bifromq.basekv.localengine.AbstractKVSpace;
import org.apache.bifromq.basekv.localengine.IKVSpaceRefreshableReader;
import org.apache.bifromq.basekv.localengine.ISyncContext;
import org.apache.bifromq.basekv.localengine.SyncContext;
import org.apache.bifromq.basekv.localengine.memory.InMemKVEngine;
import org.apache.bifromq.basekv.localengine.memory.InMemKVHelper;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpaceEpoch;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpaceReader;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpaceWriterHelper;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceOpMeters;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.slf4j.Logger;

abstract class InMemKVSpace<E extends InMemKVEngine<E, T>, T extends InMemKVSpace<E, T>>
extends AbstractKVSpace<InMemKVSpaceEpoch> {
    protected final E engine;
    protected final ISyncContext syncContext = new SyncContext();
    protected final ISyncContext.IRefresher metadataRefresher = this.syncContext.refresher();
    protected final TrackedBoundaryIndex tracker = new TrackedBoundaryIndex();

    protected InMemKVSpace(String id, Struct conf, E engine, Runnable onDestroy, KVSpaceOpMeters opMeters, Logger logger, String ... tags) {
        super(id, onDestroy, opMeters, logger, tags);
        this.engine = engine;
    }

    ISyncContext syncContext() {
        return this.syncContext;
    }

    public IKVSpaceRefreshableReader reader() {
        return new InMemKVSpaceReader(this.id, this.opMeters, this.logger, this.syncContext.refresher(), () -> (InMemKVSpaceEpoch)this.handle(), this.tracker);
    }

    protected void loadMetadata() {
        this.metadataRefresher.runIfNeeded(genBumped -> {
            if (!((InMemKVSpaceEpoch)this.handle()).metadataMap().isEmpty()) {
                this.updateMetadata(Collections.unmodifiableMap(((InMemKVSpaceEpoch)this.handle()).metadataMap()));
            }
        });
    }

    protected long doSize(Boundary boundary) {
        if (!boundary.hasStartKey() && !boundary.hasEndKey()) {
            return ((InMemKVSpaceEpoch)this.handle()).totalDataBytes();
        }
        return this.tracker.sizeOrTrack((InMemKVSpaceEpoch)this.handle(), boundary);
    }

    static final class TrackedBoundaryIndex {
        private static final int MAX_TRACKED = 1024;
        private final NavigableMap<Boundary, TrackedBucket> buckets = new ConcurrentSkipListMap<Boundary, TrackedBucket>(BoundaryUtil::compare);

        TrackedBoundaryIndex() {
        }

        long sizeOrTrack(InMemKVSpaceEpoch epoch, Boundary boundary) {
            TrackedBucket b = (TrackedBucket)this.buckets.get(boundary);
            if (b != null) {
                b.touch();
                return b.bytes;
            }
            long sized = InMemKVHelper.sizeOfRange(epoch.dataMap(), boundary);
            if (this.buckets.size() >= 1024) {
                this.buckets.pollFirstEntry();
            }
            this.buckets.put(boundary, new TrackedBucket(sized));
            return sized;
        }

        void updateOnWrite(InMemKVSpaceWriterHelper.WriteImpact impact, NavigableMap<ByteString, ByteString> data) {
            if (impact == null || this.buckets.isEmpty()) {
                return;
            }
            Map<ByteString, Integer> delta = impact.pointDeltaBytes();
            if (delta == null || delta.isEmpty()) {
                return;
            }
            long now = System.nanoTime();
            for (Map.Entry e : this.buckets.entrySet()) {
                Boundary tracked = (Boundary)e.getKey();
                TrackedBucket bucket = (TrackedBucket)e.getValue();
                long deltaSum = 0L;
                for (Map.Entry<ByteString, Integer> de : delta.entrySet()) {
                    if (!BoundaryUtil.inRange((ByteString)de.getKey(), (Boundary)tracked)) continue;
                    deltaSum += (long)de.getValue().intValue();
                }
                if (deltaSum == 0L) continue;
                long newBytes = bucket.bytes + deltaSum;
                bucket.bytes = Math.max(newBytes, 0L);
                bucket.lastAccessNanos = now;
            }
        }

        void invalidateAll() {
            this.buckets.clear();
        }

        private static final class TrackedBucket {
            volatile long bytes;
            volatile long lastAccessNanos;

            TrackedBucket(long bytes) {
                this.bytes = bytes;
                this.lastAccessNanos = System.nanoTime();
            }

            void touch() {
                this.lastAccessNanos = System.nanoTime();
            }
        }
    }
}

