/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.range;

import com.google.protobuf.ByteString;
import java.util.HashSet;
import java.util.Set;
import org.apache.bifromq.basekv.localengine.ICPableKVSpace;
import org.apache.bifromq.basekv.localengine.IKVSpaceMigratableWriter;
import org.apache.bifromq.basekv.localengine.IKVSpaceWriter;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.proto.KVRangeSnapshot;
import org.apache.bifromq.basekv.proto.State;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.store.api.IKVWriter;
import org.apache.bifromq.basekv.store.range.IKVRangeRestoreSession;
import org.apache.bifromq.basekv.store.range.IKVRangeWritable;
import org.apache.bifromq.basekv.store.range.IKVRangeWriter;
import org.apache.bifromq.basekv.store.range.KVRangeKeys;
import org.apache.bifromq.basekv.store.range.KVRangeRestoreSession;
import org.apache.bifromq.basekv.store.range.KVWriter;
import org.apache.bifromq.basekv.store.util.KVUtil;
import org.apache.bifromq.basekv.utils.KVRangeIdUtil;

class KVRangeWriter
implements IKVRangeWriter<KVRangeWriter> {
    private final KVRangeId id;
    private final ICPableKVSpace space;
    private final IKVSpaceMigratableWriter spaceWriter;
    private final Set<IKVRangeRestoreSession> activeRestoreSessions = new HashSet<IKVRangeRestoreSession>();

    KVRangeWriter(KVRangeId id, ICPableKVSpace space) {
        this.id = id;
        this.space = space;
        this.spaceWriter = space.toWriter();
    }

    @Override
    public KVRangeId id() {
        return this.id;
    }

    @Override
    public final KVRangeWriter ver(long ver) {
        this.spaceWriter.metadata(KVRangeKeys.METADATA_VER_BYTES, KVUtil.toByteStringNativeOrder(ver));
        return this;
    }

    @Override
    public final KVRangeWriter lastAppliedIndex(long lastAppliedIndex) {
        this.spaceWriter.metadata(KVRangeKeys.METADATA_LAST_APPLIED_INDEX_BYTES, KVUtil.toByteString(lastAppliedIndex));
        return this;
    }

    @Override
    public final KVRangeWriter boundary(Boundary boundary) {
        this.spaceWriter.metadata(KVRangeKeys.METADATA_RANGE_BOUND_BYTES, boundary.toByteString());
        return this;
    }

    @Override
    public final KVRangeWriter state(State state) {
        this.spaceWriter.metadata(KVRangeKeys.METADATA_STATE_BYTES, state.toByteString());
        return this;
    }

    @Override
    public final KVRangeWriter clusterConfig(ClusterConfig clusterConfig) {
        this.spaceWriter.metadata(KVRangeKeys.METADATA_CLUSTER_CONFIG_BYTES, clusterConfig.toByteString());
        return this;
    }

    @Override
    public void migrateTo(KVRangeId targetRangeId, KVRangeSnapshot snapshot) {
        this.activeRestoreSessions.add(new KVRangeRestoreSession(this.spaceWriter.migrateTo(KVRangeIdUtil.toString((KVRangeId)targetRangeId), snapshot.getBoundary())).ver(snapshot.getVer()).lastAppliedIndex(snapshot.getLastAppliedIndex()).boundary(snapshot.getBoundary()).state(snapshot.getState()).clusterConfig(snapshot.getClusterConfig()));
    }

    @Override
    public IKVRangeWritable.Migrater startMerging(IKVRangeWritable.MigrationProgressListener progressListener) {
        final KVRangeRestoreSession restoreSession = new KVRangeRestoreSession(this.space.startReceiving(progressListener::onProgress));
        this.activeRestoreSessions.add(restoreSession);
        return new IKVRangeWritable.Migrater(){

            @Override
            public IKVRangeWritable.Migrater ver(long ver) {
                restoreSession.ver(ver);
                return this;
            }

            @Override
            public IKVRangeWritable.Migrater state(State state) {
                restoreSession.state(state);
                return this;
            }

            @Override
            public IKVRangeWritable.Migrater boundary(Boundary boundary) {
                restoreSession.boundary(boundary);
                return this;
            }

            @Override
            public void put(ByteString key, ByteString value) {
                restoreSession.put(key, value);
            }

            @Override
            public void abort() {
                restoreSession.abort();
            }
        };
    }

    @Override
    public IKVWriter kvWriter() {
        return new KVWriter((IKVSpaceWriter)this.spaceWriter);
    }

    @Override
    public void abort() {
        this.spaceWriter.abort();
        for (IKVRangeRestoreSession session : this.activeRestoreSessions) {
            session.abort();
        }
        this.activeRestoreSessions.clear();
    }

    @Override
    public int count() {
        return this.spaceWriter.count();
    }

    @Override
    public void done() {
        this.spaceWriter.done();
        for (IKVRangeRestoreSession session : this.activeRestoreSessions) {
            session.done();
        }
        this.activeRestoreSessions.clear();
    }
}

