/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler.v3;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import java.nio.ByteBuffer;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.inbox.storage.proto.LWT;
import org.apache.bifromq.mqtt.spi.IUserPropsCustomizer;
import org.apache.bifromq.mqtt.spi.UserProperty;
import org.apache.bifromq.type.ClientInfo;
import org.apache.bifromq.type.Message;
import org.apache.bifromq.type.QoS;
import org.apache.bifromq.type.StringPair;
import org.apache.bifromq.type.UserProperties;

public final class MQTT3MessageUtils {
    static LWT toWillMessage(MqttConnectMessage connMsg, ClientInfo publisher, IUserPropsCustomizer userPropsCustomizer) {
        String willTopic = connMsg.payload().willTopic();
        QoS willQoS = QoS.forNumber((int)connMsg.variableHeader().willQos());
        ByteString willPayload = UnsafeByteOperations.unsafeWrap((byte[])connMsg.payload().willMessageInBytes());
        long now = HLC.INST.get();
        Iterable extraUserProps = userPropsCustomizer.inbound(willTopic, willQoS, willPayload, publisher, now);
        Message willMsg = MQTT3MessageUtils.toMessage(0L, willQoS, connMsg.variableHeader().isWillRetain(), willPayload, now, extraUserProps);
        return LWT.newBuilder().setTopic(willTopic).setMessage(willMsg).build();
    }

    static Message toMessage(MqttPublishMessage pubMsg, ClientInfo publisher, IUserPropsCustomizer userPropsCustomizer) {
        String topic = pubMsg.variableHeader().topicName();
        QoS pubQoS = QoS.forNumber((int)pubMsg.fixedHeader().qosLevel().value());
        ByteString payload = ByteString.copyFrom((ByteBuffer)pubMsg.payload().nioBuffer());
        long now = HLC.INST.get();
        Iterable extraUserProps = userPropsCustomizer.inbound(topic, pubQoS, payload, publisher, now);
        long pubMsgId = pubMsg.variableHeader().packetId();
        boolean isRetain = pubMsg.fixedHeader().isRetain();
        return MQTT3MessageUtils.toMessage(pubMsgId, pubQoS, isRetain, payload, now, extraUserProps);
    }

    static Message toMessage(long packetId, QoS pubQoS, boolean isRetain, ByteString payload, long hlc, Iterable<UserProperty> extraUserProps) {
        UserProperties.Builder userPropsBuilder = UserProperties.newBuilder();
        for (UserProperty userProp : extraUserProps) {
            userPropsBuilder.addUserProperties(StringPair.newBuilder().setKey(userProp.key()).setValue(userProp.value()).build());
        }
        return Message.newBuilder().setMessageId(packetId).setPubQoS(pubQoS).setPayload(payload).setTimestamp(hlc).setExpiryInterval(Integer.MAX_VALUE).setIsRetain(isRetain).setUserProperties(userPropsBuilder.build()).build();
    }
}

