/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler;

import java.util.concurrent.TimeUnit;

public class MPSThrottler {
    private int maxMPS;
    private long lastSec = 0L;
    private long count = 0L;

    public MPSThrottler(int maxMPS) {
        this.reset(maxMPS);
    }

    public int rateLimit() {
        return this.maxMPS;
    }

    public boolean pass() {
        long currentSec = this.upTimeInSec();
        if (this.lastSec == currentSec) {
            return ++this.count < (long)this.maxMPS;
        }
        this.count = 0L;
        this.lastSec = currentSec;
        return true;
    }

    public void reset(int maxMPS) {
        assert (maxMPS > 0);
        this.maxMPS = maxMPS;
    }

    private long upTimeInSec() {
        return TimeUnit.NANOSECONDS.toSeconds(System.nanoTime());
    }
}

