/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler;

import com.google.common.base.Strings;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpRequest;
import java.net.InetSocketAddress;
import lombok.Generated;
import org.apache.bifromq.mqtt.handler.ChannelAttrs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientAddrHandler
extends ChannelInboundHandlerAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientAddrHandler.class);
    private static final String X_REAL_IP = "X-Real-IP";
    private static final String X_REAL_PORT = "X-Real-Port";

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (ctx.channel().attr(ChannelAttrs.PEER_ADDR).get() != null) {
            ctx.fireChannelRead(msg);
            ctx.pipeline().remove((ChannelHandler)this);
            return;
        }
        if (msg instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)msg;
            String realIP = req.headers().get(X_REAL_IP);
            String realPort = req.headers().get(X_REAL_PORT);
            if (!Strings.isNullOrEmpty((String)realIP) && !Strings.isNullOrEmpty((String)realPort)) {
                int port = 0;
                try {
                    port = Integer.parseInt(realPort);
                }
                catch (Exception e) {
                    log.warn("Invalid forwarded port number: {}", (Object)realPort);
                }
                ChannelAttrs.socketAddress(ctx, new InetSocketAddress(realIP, port));
            }
        }
        ctx.fireChannelRead(msg);
        ctx.pipeline().remove((ChannelHandler)this);
    }
}

