/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler;

import java.util.concurrent.TimeUnit;

final class AdaptiveReceiveQuota {
    private static final double EPS_LOW = 0.05;
    private static final double EPS_HIGH = 0.15;
    private static final double SHRINK_RATIO = 0.1;
    private static final double U_LOW = 0.05;
    private static final double U_HIGH = 0.1;
    private static final double U_TARGET = 0.075;
    private static final double AMP_MIN = 1.1;
    private static final double AMP_MAX = 2.0;
    private static final double HEALTHY_SHRINK = 0.05;
    private static final long EVAL_PERIOD_NANOS = TimeUnit.MILLISECONDS.toNanos(200L);
    private static final long SHRINK_COOLDOWN_NANOS = TimeUnit.MILLISECONDS.toNanos(300L);
    private static final long ERROR_FREEZE_NANOS = TimeUnit.MILLISECONDS.toNanos(300L);
    private static final double BASE_FLOOR_ALPHA = 0.01;
    private final int recvMin;
    private final int recvMax;
    private final double emaAlpha;
    private double fastLatencyEWMA = 0.0;
    private double slowLatencyEWMA = 0.0;
    private double baseFloorNanos = 0.0;
    private int quotaEstimate;
    private int lastInflight = 0;
    private long lastEvalAtNanos = 0L;
    private long growthFreezeUntilNanos = 0L;

    AdaptiveReceiveQuota(int receiveMin, int receiveMax, double emaAlpha) {
        assert (receiveMin > 0 && receiveMin <= receiveMax);
        this.recvMin = receiveMin;
        this.recvMax = receiveMax;
        this.emaAlpha = Math.min(1.0, Math.max(0.0, emaAlpha));
        this.quotaEstimate = this.recvMin;
    }

    void onPacketAcked(long ackTimeNanos, long lastSendTimeNanos, int inflightCountAtAck) {
        long rtt = ackTimeNanos - lastSendTimeNanos;
        if (rtt > 0L) {
            this.fastLatencyEWMA = this.ewma(this.fastLatencyEWMA, rtt, this.emaAlpha);
            if (this.slowLatencyEWMA == 0.0) {
                this.slowLatencyEWMA = rtt;
            } else {
                double alphaSlowUp = Math.max(0.02, this.emaAlpha * 0.5);
                double alphaSlowDown = Math.max(0.005, this.emaAlpha * 0.1);
                double a = this.fastLatencyEWMA > this.slowLatencyEWMA ? alphaSlowUp : alphaSlowDown;
                this.slowLatencyEWMA = this.ewma(this.slowLatencyEWMA, rtt, a);
            }
            this.baseFloorNanos = this.baseFloorNanos == 0.0 ? (double)rtt : this.decayFloor(this.baseFloorNanos, this.slowLatencyEWMA);
        }
        this.lastInflight = Math.max(0, inflightCountAtAck);
        this.maybeEvaluate(ackTimeNanos);
    }

    void onErrorSignal(long nowNanos) {
        if (nowNanos - this.lastEvalAtNanos < SHRINK_COOLDOWN_NANOS) {
            return;
        }
        this.quotaEstimate = this.clampWindow((int)Math.ceil((double)this.quotaEstimate * (1.0 - Math.min(1.0, 0.1))));
        this.growthFreezeUntilNanos = nowNanos + ERROR_FREEZE_NANOS;
        this.lastEvalAtNanos = nowNanos;
    }

    int availableQuota() {
        return this.clampWindow(this.quotaEstimate);
    }

    private void maybeEvaluate(long nowNanos) {
        if (this.lastEvalAtNanos == 0L) {
            this.lastEvalAtNanos = nowNanos;
            return;
        }
        while (nowNanos - this.lastEvalAtNanos >= EVAL_PERIOD_NANOS) {
            long evalAt = this.lastEvalAtNanos + EVAL_PERIOD_NANOS;
            this.evaluateOnce(evalAt);
            this.lastEvalAtNanos = evalAt;
        }
    }

    private void evaluateOnce(long evalAtNanos) {
        if (evalAtNanos < this.growthFreezeUntilNanos) {
            return;
        }
        double baseCandidate = this.slowLatencyEWMA > 0.0 ? this.slowLatencyEWMA : (double)TimeUnit.MILLISECONDS.toNanos(1L);
        double base = Math.max(baseCandidate, this.baseFloorNanos);
        if (base <= 0.0 || this.fastLatencyEWMA <= 0.0) {
            return;
        }
        double r = this.fastLatencyEWMA / base;
        if (r >= 1.15) {
            this.quotaEstimate = this.clampWindow((int)Math.ceil((double)this.quotaEstimate * 0.9));
            this.growthFreezeUntilNanos = evalAtNanos + SHRINK_COOLDOWN_NANOS;
        } else if (r <= 1.05) {
            int newW;
            int w = Math.max(this.recvMin, this.quotaEstimate);
            double util = (double)this.lastInflight / (double)w;
            if (util > 0.1) {
                double factor = Math.max(1.1, Math.min(2.0, util / 0.075));
                int newW2 = this.clampWindow((int)Math.ceil((double)w * factor));
                if (newW2 > w) {
                    this.quotaEstimate = newW2;
                }
            } else if (util < 0.05 && (newW = this.clampWindow((int)Math.ceil((double)w * 0.95))) < w) {
                this.quotaEstimate = newW;
            }
        }
    }

    private int clampWindow(int value) {
        return Math.min(this.recvMax, Math.max(this.recvMin, value));
    }

    private double ewma(double current, double sample, double alpha) {
        return current == 0.0 ? sample : (1.0 - alpha) * current + alpha * sample;
    }

    private double decayFloor(double floor, double target) {
        if (target > floor) {
            return floor + 0.01 * (target - floor);
        }
        return floor;
    }
}

