/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.rocksdb;

import com.google.protobuf.Struct;
import java.util.EnumSet;
import org.apache.bifromq.basekv.localengine.StructUtil;
import org.apache.bifromq.basekv.localengine.rocksdb.AutoCleaner;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.Cache;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.DataBlockIndexType;
import org.rocksdb.Env;
import org.rocksdb.Filter;
import org.rocksdb.HistogramType;
import org.rocksdb.IndexType;
import org.rocksdb.LRUCache;
import org.rocksdb.PrepopulateBlobCache;
import org.rocksdb.RateLimiter;
import org.rocksdb.Statistics;
import org.rocksdb.StatsLevel;
import org.rocksdb.TableFormatConfig;

final class RocksDBOptionsUtil {
    RocksDBOptionsUtil() {
    }

    private static DBOptions buildDBOptions(Struct conf) {
        DBOptions opts = new DBOptions();
        opts.setEnv(Env.getDefault()).setCreateIfMissing(true).setCreateMissingColumnFamilies(true).setAvoidUnnecessaryBlockingIO(true).setMaxManifestFileSize(0x4000000L).setMaxLogFileSize(0x8000000L).setKeepLogFileNum(4L).setRecycleLogFileNum(4L).setWalSizeLimitMB(0L).setWalTtlSeconds(0L).setEnablePipelinedWrite(true).setTwoWriteQueues(false).setRateLimiter(AutoCleaner.autoRelease(new RateLimiter(0x20000000L, 100000L, 10, RateLimiter.DEFAULT_MODE, true), opts)).setMaxOpenFiles(256).setIncreaseParallelism((int)StructUtil.numVal((Struct)conf, (String)"increaseParallelism")).setMaxBackgroundJobs((int)StructUtil.numVal((Struct)conf, (String)"maxBackgroundJobs"));
        opts.setAtomicFlush(false);
        if (StructUtil.boolVal((Struct)conf, (String)"enableStats")) {
            EnumSet<HistogramType> ignoreTypes = EnumSet.allOf(HistogramType.class);
            ignoreTypes.remove(HistogramType.DB_GET);
            ignoreTypes.remove(HistogramType.DB_WRITE);
            ignoreTypes.remove(HistogramType.DB_SEEK);
            ignoreTypes.remove(HistogramType.SST_READ_MICROS);
            ignoreTypes.remove(HistogramType.SST_WRITE_MICROS);
            ignoreTypes.remove(HistogramType.BLOB_DB_GET_MICROS);
            ignoreTypes.remove(HistogramType.BLOB_DB_WRITE_MICROS);
            ignoreTypes.remove(HistogramType.FLUSH_TIME);
            ignoreTypes.remove(HistogramType.COMPACTION_TIME);
            Statistics statistics = new Statistics(ignoreTypes);
            String level = StructUtil.strVal((Struct)conf, (String)"statsLevel");
            statistics.setStatsLevel(StatsLevel.valueOf((String)level));
            opts.setStatistics(statistics);
        }
        return opts;
    }

    static DBOptions buildCPableDBOption(Struct conf) {
        DBOptions dbOptions = RocksDBOptionsUtil.buildDBOptions(conf);
        dbOptions.setRecycleLogFileNum(0L).setAllowConcurrentMemtableWrite(true).setBytesPerSync(0x100000L);
        return dbOptions;
    }

    static DBOptions buildWALableDBOption(Struct conf) {
        DBOptions dbOptions = RocksDBOptionsUtil.buildDBOptions(conf);
        dbOptions.setManualWalFlush(StructUtil.boolVal((Struct)conf, (String)"asyncWALFlush")).setBytesPerSync(0x100000L).setAllowConcurrentMemtableWrite(true);
        return dbOptions;
    }

    static ColumnFamilyDescriptor buildCPableCFDesc(String name, Struct conf) {
        ColumnFamilyOptions cfOptions = RocksDBOptionsUtil.buildCFOptions(conf);
        cfOptions.setCompressionType(CompressionType.NO_COMPRESSION);
        return new ColumnFamilyDescriptor(name.getBytes(), cfOptions);
    }

    static ColumnFamilyDescriptor buildWAlableCFDesc(String name, Struct conf) {
        return new ColumnFamilyDescriptor(name.getBytes(), RocksDBOptionsUtil.buildCFOptions(conf));
    }

    private static ColumnFamilyOptions buildCFOptions(Struct conf) {
        ColumnFamilyOptions cfOptions = new ColumnFamilyOptions();
        cfOptions.setMergeOperatorName("uint64add").setTableFormatConfig((TableFormatConfig)new BlockBasedTableConfig().setIndexType(IndexType.kTwoLevelIndexSearch).setFilterPolicy((Filter)AutoCleaner.autoRelease(new BloomFilter(16.0, false), cfOptions)).setPartitionFilters(true).setMetadataBlockSize(8192L).setCacheIndexAndFilterBlocks(true).setPinTopLevelIndexAndFilter(true).setCacheIndexAndFilterBlocksWithHighPriority(true).setPinL0FilterAndIndexBlocksInCache(true).setDataBlockIndexType(DataBlockIndexType.kDataBlockBinaryAndHash).setDataBlockHashTableUtilRatio(0.75).setBlockSize(4096L).setBlockCache((Cache)AutoCleaner.autoRelease(new LRUCache((long)StructUtil.numVal((Struct)conf, (String)"blockCacheSize"), 8), cfOptions))).setForceConsistencyChecks(true).setCompactionStyle(CompactionStyle.LEVEL).setPrepopulateBlobCache(PrepopulateBlobCache.PREPOPULATE_BLOB_FLUSH_ONLY).setCompressionType(CompressionType.LZ4_COMPRESSION).setBottommostCompressionType(CompressionType.ZSTD_COMPRESSION).setWriteBufferSize((long)StructUtil.numVal((Struct)conf, (String)"writeBufferSize")).setMaxWriteBufferNumber((int)StructUtil.numVal((Struct)conf, (String)"maxWriteBufferNumber")).setMinWriteBufferNumberToMerge((int)StructUtil.numVal((Struct)conf, (String)"minWriteBufferNumberToMerge")).setLevel0FileNumCompactionTrigger((int)StructUtil.numVal((Struct)conf, (String)"level0FileNumCompactionTrigger")).setMaxBytesForLevelBase((long)StructUtil.numVal((Struct)conf, (String)"maxBytesForLevelBase")).setTargetFileSizeBase((long)StructUtil.numVal((Struct)conf, (String)"targetFileSizeBase")).setMemtablePrefixBloomSizeRatio(0.125).setLevel0SlowdownWritesTrigger((int)StructUtil.numVal((Struct)conf, (String)"level0SlowdownWritesTrigger")).setLevel0StopWritesTrigger((int)StructUtil.numVal((Struct)conf, (String)"level0StopWritesTrigger")).setLevelCompactionDynamicLevelBytes(false).setEnableBlobFiles(true).setPrepopulateBlobCache(PrepopulateBlobCache.PREPOPULATE_BLOB_FLUSH_ONLY).setMinBlobSize((long)StructUtil.numVal((Struct)conf, (String)"minBlobSize")).enableBlobGarbageCollection();
        return cfOptions;
    }
}

