/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.apiserver.http.handler;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.Path;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.apiserver.Headers;
import org.apache.bifromq.apiserver.http.handler.TenantAwareHandler;
import org.apache.bifromq.apiserver.http.handler.utils.HeaderUtils;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.retain.client.IRetainClient;
import org.apache.bifromq.retain.rpc.proto.ExpireAllReply;
import org.apache.bifromq.retain.rpc.proto.ExpireAllRequest;

@Path(value="/retain")
final class ExpireRetainHandler
extends TenantAwareHandler {
    private final IRetainClient retainClient;

    ExpireRetainHandler(ISettingProvider settingProvider, IRetainClient retainClient) {
        super(settingProvider);
        this.retainClient = retainClient;
    }

    @Override
    @DELETE
    @Operation(summary="Expire all retain messages using given expiry time")
    @Parameters(value={@Parameter(name="req_id", in=ParameterIn.HEADER, description="optional caller provided request id", schema=@Schema(implementation=Long.class)), @Parameter(name="tenant_id", in=ParameterIn.HEADER, required=true, description="the tenant id", schema=@Schema(implementation=String.class)), @Parameter(name="expiry_seconds", in=ParameterIn.HEADER, required=true, description="the overridden retain message expiry time in seconds", schema=@Schema(implementation=Integer.class))})
    @RequestBody(required=false)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success")})
    public CompletableFuture<FullHttpResponse> handle(@Parameter(hidden=true) long reqId, @Parameter(hidden=true) String tenantId, @Parameter(hidden=true) FullHttpRequest req) {
        int expirySeconds = Integer.parseInt(HeaderUtils.getHeader(Headers.HEADER_EXPIRY_SECONDS, (HttpRequest)req, true));
        ExpireAllRequest.Builder reqBuilder = ExpireAllRequest.newBuilder().setReqId(reqId).setExpirySeconds(expirySeconds).setNow(HLC.INST.getPhysical());
        if (tenantId != null) {
            reqBuilder.setTenantId(tenantId);
        }
        return this.retainClient.expireAll(reqBuilder.build()).thenApply(r -> new DefaultFullHttpResponse(req.protocolVersion(), r.getResult() == ExpireAllReply.Result.OK ? HttpResponseStatus.OK : HttpResponseStatus.TOO_MANY_REQUESTS, Unpooled.EMPTY_BUFFER));
    }
}

