/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.message;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.compute.message.JobResultRequest;
import org.apache.ignite.internal.compute.message.JobResultRequestBuilder;
import org.apache.ignite.internal.compute.message.JobResultRequestSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class JobResultRequestImpl
implements JobResultRequest,
Cloneable {
    public static final short GROUP_TYPE = 6;
    public static final short TYPE = 3;
    @IgniteToStringInclude
    private final UUID jobId;

    private JobResultRequestImpl(UUID jobId) {
        this.jobId = jobId;
    }

    @Override
    public UUID jobId() {
        return this.jobId;
    }

    public MessageSerializer serializer() {
        return JobResultRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 6;
    }

    public String toString() {
        return S.toString(JobResultRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 3;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        JobResultRequestImpl otherMessage = (JobResultRequestImpl)other;
        return Objects.equals(this.jobId, otherMessage.jobId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.jobId);
        return result;
    }

    public JobResultRequestImpl clone() {
        try {
            return (JobResultRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static JobResultRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements JobResultRequestBuilder {
        private UUID jobId;

        private Builder() {
        }

        @Override
        public JobResultRequestBuilder jobId(UUID jobId) {
            Objects.requireNonNull(jobId, "jobId is not marked @Nullable");
            this.jobId = jobId;
            return this;
        }

        @Override
        public UUID jobId() {
            return this.jobId;
        }

        @Override
        public JobResultRequest build() {
            return new JobResultRequestImpl(Objects.requireNonNull(this.jobId, "jobId is not marked @Nullable"));
        }
    }
}

