/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.authentication.AuthenticationException;
import io.micronaut.security.authentication.AuthenticationFailed;
import io.micronaut.security.authentication.AuthenticationFailureReason;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

@FunctionalInterface
public interface AuthenticationResponse
extends Serializable {
    default public boolean isAuthenticated() {
        return this.getAuthentication().isPresent();
    }

    public Optional<Authentication> getAuthentication();

    default public Optional<String> getMessage() {
        return Optional.empty();
    }

    @NonNull
    public static AuthenticationResponse success(@NonNull String username) {
        return AuthenticationResponse.success(username, Collections.emptyList(), Collections.emptyMap());
    }

    @NonNull
    public static AuthenticationResponse success(@NonNull String username, @NonNull Collection<String> roles) {
        return AuthenticationResponse.success(username, roles, Collections.emptyMap());
    }

    @NonNull
    public static AuthenticationResponse success(@NonNull String username, @NonNull Map<String, Object> attributes) {
        return () -> Optional.of(Authentication.build(username, Collections.emptyList(), attributes));
    }

    @NonNull
    public static AuthenticationResponse success(@NonNull String username, @NonNull Collection<String> roles, @NonNull Map<String, Object> attributes) {
        return () -> Optional.of(Authentication.build(username, roles, attributes));
    }

    @NonNull
    public static AuthenticationResponse failure(@NonNull String message) {
        return new AuthenticationFailed(message);
    }

    @NonNull
    public static AuthenticationResponse failure(@NonNull AuthenticationFailureReason reason) {
        return new AuthenticationFailed(reason);
    }

    @NonNull
    public static AuthenticationResponse failure() {
        return new AuthenticationFailed();
    }

    @NonNull
    public static AuthenticationException exception(@NonNull String message) {
        return new AuthenticationException(new AuthenticationFailed(message));
    }

    @NonNull
    public static AuthenticationException exception(@NonNull AuthenticationFailureReason reason) {
        return new AuthenticationException(new AuthenticationFailed(reason));
    }

    @NonNull
    public static AuthenticationException exception() {
        return new AuthenticationException(new AuthenticationFailed());
    }
}

