/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestCharArrayBuffer {
    TestCharArrayBuffer() {
    }

    @Test
    void testConstructor() {
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        Assertions.assertEquals((int)16, (int)buffer.capacity());
        Assertions.assertEquals((int)0, (int)buffer.length());
        Assertions.assertNotNull((Object)buffer.array());
        Assertions.assertEquals((int)16, (int)buffer.array().length);
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CharArrayBuffer(-1));
    }

    @Test
    void testSimpleAppend() {
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        Assertions.assertEquals((int)16, (int)buffer.capacity());
        Assertions.assertEquals((int)0, (int)buffer.length());
        char[] b1 = buffer.toCharArray();
        Assertions.assertNotNull((Object)b1);
        Assertions.assertEquals((int)0, (int)b1.length);
        Assertions.assertTrue((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
        char[] tmp = new char[]{'1', '2', '3', '4'};
        buffer.append(tmp, 0, tmp.length);
        Assertions.assertEquals((int)16, (int)buffer.capacity());
        Assertions.assertEquals((int)4, (int)buffer.length());
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
        char[] b2 = buffer.toCharArray();
        Assertions.assertNotNull((Object)b2);
        Assertions.assertEquals((int)4, (int)b2.length);
        for (int i = 0; i < tmp.length; ++i) {
            Assertions.assertEquals((char)tmp[i], (char)b2[i]);
            Assertions.assertEquals((char)tmp[i], (char)buffer.charAt(i));
        }
        Assertions.assertEquals((Object)"1234", (Object)buffer.toString());
        buffer.clear();
        Assertions.assertEquals((int)16, (int)buffer.capacity());
        Assertions.assertEquals((int)0, (int)buffer.length());
        Assertions.assertTrue((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
    }

    @Test
    void testExpandAppend() {
        CharArrayBuffer buffer = new CharArrayBuffer(4);
        Assertions.assertEquals((int)4, (int)buffer.capacity());
        char[] tmp = new char[]{'1', '2', '3', '4'};
        buffer.append(tmp, 0, 2);
        buffer.append(tmp, 0, 4);
        buffer.append(tmp, 0, 0);
        Assertions.assertEquals((int)8, (int)buffer.capacity());
        Assertions.assertEquals((int)6, (int)buffer.length());
        buffer.append(tmp, 0, 4);
        Assertions.assertEquals((int)16, (int)buffer.capacity());
        Assertions.assertEquals((int)10, (int)buffer.length());
        Assertions.assertEquals((Object)"1212341234", (Object)buffer.toString());
    }

    @Test
    void testAppendString() {
        CharArrayBuffer buffer = new CharArrayBuffer(8);
        buffer.append("stuff");
        buffer.append(" and more stuff");
        Assertions.assertEquals((Object)"stuff and more stuff", (Object)buffer.toString());
    }

    @Test
    void testAppendNullString() {
        CharArrayBuffer buffer = new CharArrayBuffer(8);
        buffer.append((String)null);
        Assertions.assertEquals((Object)"null", (Object)buffer.toString());
    }

    @Test
    void testAppendCharArrayBuffer() {
        CharArrayBuffer buffer1 = new CharArrayBuffer(8);
        buffer1.append(" and more stuff");
        CharArrayBuffer buffer2 = new CharArrayBuffer(8);
        buffer2.append("stuff");
        buffer2.append(buffer1);
        Assertions.assertEquals((Object)"stuff and more stuff", (Object)buffer2.toString());
    }

    @Test
    void testAppendNullCharArrayBuffer() {
        CharArrayBuffer buffer = new CharArrayBuffer(8);
        buffer.append((CharArrayBuffer)null);
        buffer.append((CharArrayBuffer)null, 0, 0);
        Assertions.assertEquals((Object)"", (Object)buffer.toString());
    }

    @Test
    void testAppendSingleChar() {
        CharArrayBuffer buffer = new CharArrayBuffer(4);
        buffer.append('1');
        buffer.append('2');
        buffer.append('3');
        buffer.append('4');
        buffer.append('5');
        buffer.append('6');
        Assertions.assertEquals((Object)"123456", (Object)buffer.toString());
    }

    @Test
    void testInvalidCharArrayAppend() {
        CharArrayBuffer buffer = new CharArrayBuffer(4);
        buffer.append((char[])null, 0, 0);
        char[] tmp = new char[]{'1', '2', '3', '4'};
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, -1, 0));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, 0, -1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, 0, 8));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, 10, Integer.MAX_VALUE));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, 2, 4));
    }

    @Test
    void testSetLength() {
        CharArrayBuffer buffer = new CharArrayBuffer(4);
        buffer.setLength(2);
        Assertions.assertEquals((int)2, (int)buffer.length());
    }

    @Test
    void testSetInvalidLength() {
        CharArrayBuffer buffer = new CharArrayBuffer(4);
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.setLength(-2));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.setLength(200));
    }

    @Test
    void testEnsureCapacity() {
        CharArrayBuffer buffer = new CharArrayBuffer(4);
        buffer.ensureCapacity(2);
        Assertions.assertEquals((int)4, (int)buffer.capacity());
        buffer.ensureCapacity(8);
        Assertions.assertEquals((int)8, (int)buffer.capacity());
    }

    @Test
    void testIndexOf() {
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        buffer.append("name: value");
        Assertions.assertEquals((int)4, (int)buffer.indexOf(58));
        Assertions.assertEquals((int)-1, (int)buffer.indexOf(44));
        Assertions.assertEquals((int)4, (int)buffer.indexOf(58, -1, 11));
        Assertions.assertEquals((int)4, (int)buffer.indexOf(58, 0, 1000));
        Assertions.assertEquals((int)-1, (int)buffer.indexOf(58, 2, 1));
    }

    @Test
    void testSubstring() {
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        buffer.append(" name:  value    ");
        Assertions.assertEquals((int)5, (int)buffer.indexOf(58));
        Assertions.assertEquals((Object)" name", (Object)buffer.substring(0, 5));
        Assertions.assertEquals((Object)"  value    ", (Object)buffer.substring(6, buffer.length()));
        Assertions.assertEquals((Object)"name", (Object)buffer.substringTrimmed(0, 5));
        Assertions.assertEquals((Object)"value", (Object)buffer.substringTrimmed(6, buffer.length()));
        Assertions.assertEquals((Object)"", (Object)buffer.substringTrimmed(13, buffer.length()));
    }

    @Test
    void testSubstringIndexOfOutBound() {
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        buffer.append("stuff");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.substring(-2, 10));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.substringTrimmed(-2, 10));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.substring(12, 10));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.substringTrimmed(12, 10));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.substring(2, 1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.substringTrimmed(2, 1));
    }

    @Test
    void testAppendAsciiByteArray() {
        String s1 = "stuff";
        String s2 = " and more stuff";
        byte[] b1 = "stuff".getBytes(StandardCharsets.US_ASCII);
        byte[] b2 = " and more stuff".getBytes(StandardCharsets.US_ASCII);
        CharArrayBuffer buffer = new CharArrayBuffer(8);
        buffer.append(b1, 0, b1.length);
        buffer.append(b2, 0, b2.length);
        Assertions.assertEquals((Object)"stuff and more stuff", (Object)buffer.toString());
    }

    @Test
    void testAppendISOByteArray() {
        byte[] b = new byte[]{0, 32, 127, -128, -1};
        CharArrayBuffer buffer = new CharArrayBuffer(8);
        buffer.append(b, 0, b.length);
        char[] ch = buffer.toCharArray();
        Assertions.assertNotNull((Object)ch);
        Assertions.assertEquals((int)5, (int)ch.length);
        Assertions.assertEquals((int)0, (int)ch[0]);
        Assertions.assertEquals((int)32, (int)ch[1]);
        Assertions.assertEquals((int)127, (int)ch[2]);
        Assertions.assertEquals((int)128, (int)ch[3]);
        Assertions.assertEquals((int)255, (int)ch[4]);
    }

    @Test
    void testAppendNullByteArray() {
        CharArrayBuffer buffer = new CharArrayBuffer(8);
        buffer.append((byte[])null, 0, 0);
        Assertions.assertEquals((Object)"", (Object)buffer.toString());
    }

    @Test
    void testAppendNullByteArrayBuffer() {
        CharArrayBuffer buffer = new CharArrayBuffer(8);
        buffer.append((ByteArrayBuffer)null, 0, 0);
        Assertions.assertEquals((Object)"", (Object)buffer.toString());
    }

    @Test
    void testInvalidAppendAsciiByteArray() {
        CharArrayBuffer buffer = new CharArrayBuffer(4);
        buffer.append((byte[])null, 0, 0);
        byte[] tmp = new byte[]{49, 50, 51, 52};
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, -1, 0));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, 0, -1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, 0, 8));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, 10, Integer.MAX_VALUE));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, 2, 4));
    }

    @Test
    void testSerialization() throws Exception {
        CharArrayBuffer orig = new CharArrayBuffer(32);
        orig.append('a');
        orig.append('b');
        orig.append('c');
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        try (ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);){
            outStream.writeObject(orig);
        }
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        CharArrayBuffer clone = (CharArrayBuffer)inStream.readObject();
        Assertions.assertEquals((int)orig.capacity(), (int)clone.capacity());
        Assertions.assertEquals((int)orig.length(), (int)clone.length());
        char[] data = clone.toCharArray();
        Assertions.assertNotNull((Object)data);
        Assertions.assertEquals((int)3, (int)data.length);
        Assertions.assertEquals((char)'a', (char)data[0]);
        Assertions.assertEquals((char)'b', (char)data[1]);
        Assertions.assertEquals((char)'c', (char)data[2]);
    }

    @Test
    void testSubSequence() {
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        buffer.append(" name:  value    ");
        Assertions.assertEquals((int)5, (int)buffer.indexOf(58));
        Assertions.assertEquals((Object)" name", (Object)buffer.subSequence(0, 5).toString());
        Assertions.assertEquals((Object)"  value    ", (Object)buffer.subSequence(6, buffer.length()).toString());
    }

    @Test
    void testSubSequenceIndexOfOutBound() {
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        buffer.append("stuff");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.subSequence(-2, 10));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.subSequence(12, 10));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.subSequence(2, 1));
    }
}

