/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.apache.directory.fortress.core.CreateException;
import org.apache.directory.fortress.core.FinderException;
import org.apache.directory.fortress.core.RemoveException;
import org.apache.directory.fortress.core.UpdateException;
import org.apache.directory.fortress.core.impl.PsoUtil;
import org.apache.directory.fortress.core.impl.UsoUtil;
import org.apache.directory.fortress.core.ldap.LdapDataProvider;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.Graphable;
import org.apache.directory.fortress.core.model.ObjectFactory;
import org.apache.directory.fortress.core.model.OrgUnit;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OrgUnitDAO
extends LdapDataProvider {
    private static final String CLS_NM = OrgUnitDAO.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private static final String ORGUNIT_OBJECT_CLASS_NM = "ftOrgUnit";
    private static final String[] ORGUNIT_OBJ_CLASS = new String[]{"top", "ftOrgUnit", "ftMods"};
    private static final String[] ORGUNIT_ATRS = new String[]{"ftId", "ou", "description", "ftParents"};
    private static final String[] ORGUNIT_ATR = new String[]{"ou"};

    OrgUnitDAO() {
    }

    OrgUnit create(OrgUnit entity) throws CreateException {
        LdapConnection ld = null;
        Dn dn = this.getDn(entity);
        try {
            DefaultEntry entry = new DefaultEntry(dn);
            entry.add("objectClass", ORGUNIT_OBJ_CLASS);
            entity.setId();
            entry.add("ftId", new String[]{entity.getId()});
            String description = entity.getDescription();
            if (!Strings.isEmpty((String)description)) {
                entry.add("description", new String[]{description});
            }
            entry.add("ou", new String[]{entity.getName()});
            this.loadAttrs(entity.getParents(), (Entry)entry, "ftParents");
            ld = this.getAdminConnection();
            this.add(ld, (Entry)entry, entity);
        }
        catch (LdapException e) {
            try {
                String error = "create orgUnit name [" + entity.getName() + "] type [" + entity.getType() + "] root [" + dn + "] caught LdapException=" + e;
                int errCode = entity.getType() == OrgUnit.Type.PERM ? 8062 : 8012;
                throw new CreateException(errCode, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return entity;
    }

    OrgUnit update(OrgUnit entity) throws UpdateException {
        LdapConnection ld = null;
        Dn dn = this.getDn(entity);
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            if (entity.getDescription() != null && entity.getDescription().length() > 0) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "description", new String[]{entity.getDescription()}));
            }
            this.loadAttrs(entity.getParents(), mods, "ftParents");
            if (mods.size() > 0) {
                ld = this.getAdminConnection();
                this.modify(ld, dn, mods, (FortEntity)entity);
            }
        }
        catch (LdapException e) {
            try {
                String error = "update orgUnit name [" + entity.getName() + "] type [" + entity.getType() + "] root [" + dn + "] caught LdapException=" + e;
                int errCode = entity.getType() == OrgUnit.Type.PERM ? 8063 : 8013;
                throw new UpdateException(errCode, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return entity;
    }

    void deleteParent(OrgUnit entity) throws UpdateException {
        LdapConnection ld = null;
        Dn dn = this.getDn(entity);
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            mods.add((Modification)new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, "ftParents"));
            ld = this.getAdminConnection();
            this.modify(ld, dn, mods, (FortEntity)entity);
        }
        catch (LdapException e) {
            try {
                String error = "deleteParent orgUnit name [" + entity.getName() + "] type [" + entity.getType() + "] root [" + dn + "] caught LdapException=" + e;
                int errCode = entity.getType() == OrgUnit.Type.PERM ? 8074 : 8021;
                throw new UpdateException(errCode, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
    }

    OrgUnit remove(OrgUnit entity) throws RemoveException {
        LdapConnection ld = null;
        Dn dn = this.getDn(entity);
        try {
            ld = this.getAdminConnection();
            this.delete(ld, dn, (FortEntity)entity);
        }
        catch (LdapException e) {
            String error = "remove orgUnit name [" + entity.getName() + "] type [" + entity.getType() + "] root [" + dn + "] caught LdapException=" + e;
            int errCode = entity.getType() == OrgUnit.Type.PERM ? 8064 : 8014;
            throw new RemoveException(errCode, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return entity;
    }

    OrgUnit findByKey(OrgUnit entity) throws FinderException {
        OrgUnit oe = null;
        LdapConnection ld = null;
        Dn dn = this.getDn(entity);
        try {
            ld = this.getAdminConnection();
            Entry findEntry = this.read(ld, dn, ORGUNIT_ATRS);
            if (findEntry == null) {
                String warning = "findByKey orgUnit name [" + entity.getName() + "] type [" + entity.getType() + "] COULD NOT FIND ENTRY for dn [" + dn + "]";
                int errCode = entity.getType() == OrgUnit.Type.PERM ? 8067 : 8017;
                throw new FinderException(errCode, warning);
            }
            oe = this.getEntityFromLdapEntry(findEntry, 0L, entity.getContextId());
        }
        catch (LdapNoSuchObjectException e) {
            String warning = "findByKey orgUnit name [" + entity.getName() + "] type [" + entity.getType() + "] COULD NOT FIND ENTRY for dn [" + dn + "]";
            int errCode = entity.getType() == OrgUnit.Type.PERM ? 8067 : 8017;
            throw new FinderException(errCode, warning);
        }
        catch (LdapException e) {
            String error = "findByKey orgUnitName [" + entity.getName() + "] type [" + entity.getType() + "] dn [" + dn + "] caught LdapException=" + e;
            int errCode = entity.getType() == OrgUnit.Type.PERM ? 8061 : 8011;
            throw new FinderException(errCode, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return oe;
    }

    List<OrgUnit> findOrgs(OrgUnit orgUnit) throws FinderException {
        ArrayList<OrgUnit> orgUnitList = new ArrayList<OrgUnit>();
        LdapConnection ld = null;
        String orgUnitRoot = this.getOrgRoot(orgUnit);
        try {
            String searchVal = this.encodeSafeText(orgUnit.getName(), 40);
            String filter = "(&(objectClass=ftOrgUnit)(ou=" + searchVal + "*))";
            ld = this.getAdminConnection();
            try (SearchCursor searchResults = this.search(ld, orgUnitRoot, SearchScope.ONELEVEL, filter, ORGUNIT_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));){
                long sequence = 0L;
                while (searchResults.next()) {
                    orgUnitList.add(this.getEntityFromLdapEntry(searchResults.getEntry(), sequence++, orgUnit.getContextId()));
                }
            }
            catch (IOException i) {
                String error = "findOrgs search val [" + orgUnit.getName() + "] type [" + orgUnit.getType() + "] root [" + orgUnitRoot + "] caught IOException=" + i;
                int errCode = orgUnit.getType() == OrgUnit.Type.PERM ? 8065 : 8015;
                throw new FinderException(errCode, error, i);
            }
            catch (CursorException e) {
                String error = "findOrgs search val [" + orgUnit.getName() + "] type [" + orgUnit.getType() + "] root [" + orgUnitRoot + "] caught CursorException=" + e;
                int errCode = orgUnit.getType() == OrgUnit.Type.PERM ? 8065 : 8015;
                throw new FinderException(errCode, error, (Exception)((Object)e));
            }
        }
        catch (LdapException e) {
            try {
                String error = "findOrgs search val [" + orgUnit.getName() + "] type [" + orgUnit.getType() + "] root [" + orgUnitRoot + "] caught LdapException=" + e;
                int errCode = orgUnit.getType() == OrgUnit.Type.PERM ? 8065 : 8015;
                throw new FinderException(errCode, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return orgUnitList;
    }

    Set<String> getOrgs(OrgUnit orgUnit) throws FinderException {
        TreeSet<String> ouSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        LdapConnection ld = null;
        String orgUnitRoot = this.getOrgRoot(orgUnit);
        try {
            String filter = "(objectclass=ftOrgUnit)";
            ld = this.getAdminConnection();
            try (SearchCursor searchResults = this.search(ld, orgUnitRoot, SearchScope.ONELEVEL, filter, ORGUNIT_ATR, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));){
                while (searchResults.next()) {
                    ouSet.add(this.getAttribute(searchResults.getEntry(), "ou"));
                }
            }
            catch (CursorException e) {
                String error = "getOrgs type [" + orgUnit.getType() + "] root [" + orgUnitRoot + "] caught CursorException=" + e;
                int errCode = orgUnit.getType() == OrgUnit.Type.PERM ? 8066 : 8016;
                throw new FinderException(errCode, error, (Exception)((Object)e));
            }
            catch (IOException e) {
                String error = "getOrgs type [" + orgUnit.getType() + "] root [" + orgUnitRoot + "] caught IOException=" + e;
                int errCode = orgUnit.getType() == OrgUnit.Type.PERM ? 8066 : 8016;
                throw new FinderException(errCode, error, e);
            }
        }
        catch (LdapException e) {
            String error = "getOrgs type [" + orgUnit.getType() + "] root [" + orgUnitRoot + "] caught LdapException=" + e;
            int errCode = orgUnit.getType() == OrgUnit.Type.PERM ? 8066 : 8016;
            throw new FinderException(errCode, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return ouSet;
    }

    List<Graphable> getAllDescendants(OrgUnit orgUnit) throws FinderException {
        String orgUnitRoot = this.getOrgRoot(orgUnit);
        String[] DESC_ATRS = new String[]{"ou", "ftParents"};
        ArrayList<Graphable> descendants = new ArrayList<Graphable>();
        LdapConnection ld = null;
        String filter = null;
        try {
            filter = "(&(objectClass=ftOrgUnit)(ftParents=*))";
            ld = this.getAdminConnection();
            try (SearchCursor searchResults = this.search(ld, orgUnitRoot, SearchScope.ONELEVEL, filter, DESC_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));){
                long sequence = 0L;
                while (searchResults.next()) {
                    descendants.add(this.unloadDescendants(searchResults.getEntry(), sequence++, orgUnit.getContextId()));
                }
            }
            catch (IOException i) {
                String error = "getAllDescendants filter [" + filter + "] caught IOException=" + i.getMessage();
                throw new FinderException(9000, error, i);
            }
            catch (CursorException e) {
                String error = "getAllDescendants filter [" + filter + "] caught CursorException=" + e.getMessage();
                throw new FinderException(9000, error, (Exception)((Object)e));
            }
        }
        catch (LdapException e) {
            String error = "getAllDescendants filter [" + filter + "] caught LdapException=" + e;
            throw new FinderException(9000, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return descendants;
    }

    private Dn getDn(OrgUnit orgUnit) {
        Dn dn = null;
        try {
            switch (orgUnit.type) {
                case USER: {
                    dn = new Dn(new String[]{"ou=" + orgUnit.getName(), OrgUnitDAO.getRootDn(orgUnit.getContextId(), "userou.root")});
                    break;
                }
                case PERM: {
                    dn = new Dn(new String[]{"ou=" + orgUnit.getName(), OrgUnitDAO.getRootDn(orgUnit.getContextId(), "permou.root")});
                    break;
                }
                default: {
                    String warning = "getDn invalid type";
                    LOG.warn(warning);
                }
            }
            return dn;
        }
        catch (LdapInvalidDnException lide) {
            LOG.error(lide.getMessage());
            throw new RuntimeException(lide.getMessage());
        }
    }

    private String getOrgRoot(OrgUnit orgUnit) {
        String dn = null;
        switch (orgUnit.type) {
            case USER: {
                dn = OrgUnitDAO.getRootDn(orgUnit.getContextId(), "userou.root");
                break;
            }
            case PERM: {
                dn = OrgUnitDAO.getRootDn(orgUnit.getContextId(), "permou.root");
                break;
            }
            default: {
                String warning = "getOrgRootDn invalid type";
                LOG.warn(warning);
            }
        }
        return dn;
    }

    private Graphable unloadDescendants(Entry le, long sequence, String contextId) throws LdapInvalidAttributeValueException {
        OrgUnit entity = new ObjectFactory().createOrgUnit();
        entity.setSequenceId(sequence);
        entity.setName(this.getAttribute(le, "ou"));
        entity.setParents(this.getAttributeSet(le, "ftParents"));
        return entity;
    }

    private OrgUnit getEntityFromLdapEntry(Entry le, long sequence, String contextId) throws LdapInvalidAttributeValueException {
        OrgUnit entity = new ObjectFactory().createOrgUnit();
        entity.setSequenceId(sequence);
        entity.setId(this.getAttribute(le, "ftId"));
        entity.setName(this.getAttribute(le, "ou"));
        entity.setDescription(this.getAttribute(le, "description"));
        String dn = le.getDn().getName();
        if (dn.toLowerCase().contains(OrgUnitDAO.getRootDn(contextId, "permou.root").toLowerCase())) {
            entity.setType(OrgUnit.Type.PERM);
            entity.setChildren(PsoUtil.getInstance().getChildren(entity.getName().toUpperCase(), contextId));
        } else if (dn.toLowerCase().contains(OrgUnitDAO.getRootDn(contextId, "userou.root").toLowerCase())) {
            entity.setType(OrgUnit.Type.USER);
            entity.setChildren(UsoUtil.getInstance().getChildren(entity.getName().toUpperCase(), contextId));
        }
        entity.setParents(this.getAttributeSet(le, "ftParents"));
        return entity;
    }
}

