/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.nio.ByteBuffer;
import org.apache.trevni.Crc32Checksum;
import org.apache.trevni.MetaData;
import org.apache.trevni.NullChecksum;
import org.apache.trevni.TrevniRuntimeException;

abstract class Checksum {
    Checksum() {
    }

    public static Checksum get(MetaData meta) {
        String name = meta.getChecksum();
        if (name == null || "null".equals(name)) {
            return new NullChecksum();
        }
        if ("crc32".equals(name)) {
            return new Crc32Checksum();
        }
        throw new TrevniRuntimeException("Unknown checksum: " + name);
    }

    public abstract int size();

    public abstract ByteBuffer compute(ByteBuffer var1);
}

