/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import lombok.Generated;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.mfa.trusteddevice.TrustedDevicesMultifactorProperties;
import org.apereo.cas.trusted.authentication.MultifactorAuthenticationTrustCipherExecutor;
import org.apereo.cas.trusted.authentication.MultifactorAuthenticationTrustedDeviceNamingStrategy;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecordKeyGenerator;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.trusted.authentication.keys.DefaultMultifactorAuthenticationTrustRecordKeyGenerator;
import org.apereo.cas.trusted.authentication.storage.InMemoryMultifactorAuthenticationTrustStorage;
import org.apereo.cas.trusted.authentication.storage.JsonMultifactorAuthenticationTrustStorage;
import org.apereo.cas.trusted.authentication.storage.MultifactorAuthenticationTrustRecordExpiry;
import org.apereo.cas.trusted.authentication.storage.MultifactorAuthenticationTrustStorageCleaner;
import org.apereo.cas.trusted.web.MultifactorAuthenticationTrustedDevicesReportEndpoint;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.util.spring.boot.ConditionalOnMatchingHostname;
import org.apereo.cas.util.thread.Cleanable;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.integration.transaction.PseudoTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.MultifactorAuthenticationTrustedDevices})
@Configuration(value="MultifactorAuthnTrustConfiguration", proxyBeanMethods=false)
class MultifactorAuthnTrustConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthnTrustConfiguration.class);
    private static final int INITIAL_CACHE_SIZE = 50;
    private static final long MAX_CACHE_SIZE = 1000000L;

    MultifactorAuthnTrustConfiguration() {
    }

    @Configuration(value="MultifactorAuthnTrustWebConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class MultifactorAuthnTrustWebConfiguration {
        MultifactorAuthnTrustWebConfiguration() {
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrustedDevicesReportEndpoint mfaTrustedDevicesReportEndpoint(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="mfaTrustEngine") ObjectProvider<MultifactorAuthenticationTrustStorage> mfaTrustEngine) {
            return new MultifactorAuthenticationTrustedDevicesReportEndpoint(casProperties, applicationContext, mfaTrustEngine);
        }
    }

    @Configuration(value="MultifactorAuthnTrustAuditConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class MultifactorAuthnTrustAuditConfiguration {
        MultifactorAuthnTrustAuditConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailRecordResolutionPlanConfigurer casMfaTrustAuditTrailRecordResolutionPlanConfigurer(@Qualifier(value="ticketCreationActionResolver") AuditActionResolver ticketCreationActionResolver, @Qualifier(value="returnValueResourceResolver") AuditResourceResolver returnValueResourceResolver) {
            return plan -> {
                plan.registerAuditResourceResolver("TRUSTED_AUTHENTICATION_RESOURCE_RESOLVER", returnValueResourceResolver);
                plan.registerAuditActionResolver("TRUSTED_AUTHENTICATION_ACTION_RESOLVER", ticketCreationActionResolver);
            };
        }
    }

    @Configuration(value="MultifactorAuthnTrustSchedulerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class MultifactorAuthnTrustSchedulerConfiguration {
        MultifactorAuthnTrustSchedulerConfiguration() {
        }

        @ConditionalOnMatchingHostname(name="cas.authn.mfa.trusted.cleaner.schedule.enabled-on-host")
        @ConditionalOnMissingBean(name={"mfaTrustStorageCleaner"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Lazy(value=false)
        public Cleanable mfaTrustStorageCleaner(ConfigurableApplicationContext applicationContext, @Qualifier(value="mfaTrustEngine") MultifactorAuthenticationTrustStorage mfaTrustEngine) {
            return (Cleanable)BeanSupplier.of(Cleanable.class).when(BeanCondition.on((String)"cas.authn.mfa.trusted.cleaner.schedule.enabled").isTrue().evenIfMissing().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new MultifactorAuthenticationTrustStorageCleaner(mfaTrustEngine)).otherwiseProxy().get();
        }
    }

    @Configuration(value="MultifactorAuthnTrustCryptoConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class MultifactorAuthnTrustCryptoConfiguration {
        MultifactorAuthnTrustCryptoConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"mfaTrustCipherExecutor"})
        public CipherExecutor mfaTrustCipherExecutor(CasConfigurationProperties casProperties) {
            EncryptionJwtSigningJwtCryptographyProperties crypto = casProperties.getAuthn().getMfa().getTrusted().getCrypto();
            if (crypto.isEnabled()) {
                return CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, MultifactorAuthenticationTrustCipherExecutor.class);
            }
            LOGGER.info("Multifactor trusted authentication record encryption/signing is turned off and MAY NOT be safe in a production environment. Consider using other choices to handle encryption, signing and verification of trusted authentication records for MFA");
            return CipherExecutor.noOp();
        }
    }

    @Configuration(value="MultifactorAuthnTrustCoreConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class MultifactorAuthnTrustCoreConfiguration {
        MultifactorAuthnTrustCoreConfiguration() {
        }

        @ConditionalOnMissingBean(name={"mfaTrustDeviceNamingStrategy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrustedDeviceNamingStrategy mfaTrustDeviceNamingStrategy() {
            return MultifactorAuthenticationTrustedDeviceNamingStrategy.random();
        }

        @ConditionalOnMissingBean(name={"mfaTrustEngine"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrustStorage mfaTrustEngine(CasConfigurationProperties casProperties, @Qualifier(value="mfaTrustCipherExecutor") CipherExecutor mfaTrustCipherExecutor, @Qualifier(value="mfaTrustRecordKeyGenerator") MultifactorAuthenticationTrustRecordKeyGenerator mfaTrustRecordKeyGenerator) {
            TrustedDevicesMultifactorProperties trusted = casProperties.getAuthn().getMfa().getTrusted();
            LoadingCache storage = Caffeine.newBuilder().initialCapacity(50).maximumSize(1000000L).expireAfter((Expiry)new MultifactorAuthenticationTrustRecordExpiry()).build(s -> {
                LOGGER.error("Load operation of the cache is not supported.");
                return null;
            });
            return (MultifactorAuthenticationTrustStorage)FunctionUtils.doIf((trusted.getJson().getLocation() != null ? 1 : 0) != 0, () -> {
                LOGGER.debug("Storing trusted device records inside the JSON resource [{}]", (Object)trusted.getJson().getLocation());
                return new JsonMultifactorAuthenticationTrustStorage(casProperties.getAuthn().getMfa().getTrusted(), mfaTrustCipherExecutor, trusted.getJson().getLocation(), mfaTrustRecordKeyGenerator);
            }, () -> {
                LOGGER.warn("Storing trusted device records in runtime memory. Changes and records will be lost upon CAS restarts");
                return new InMemoryMultifactorAuthenticationTrustStorage(casProperties.getAuthn().getMfa().getTrusted(), mfaTrustCipherExecutor, storage, mfaTrustRecordKeyGenerator);
            }).get();
        }

        @ConditionalOnMissingBean(name={"transactionManagerMfaAuthnTrust"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PlatformTransactionManager transactionManagerMfaAuthnTrust() {
            return new PseudoTransactionManager();
        }
    }

    @Configuration(value="MultifactorAuthnTrustGeneratorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class MultifactorAuthnTrustGeneratorConfiguration {
        MultifactorAuthnTrustGeneratorConfiguration() {
        }

        @ConditionalOnMissingBean(name={"mfaTrustRecordKeyGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationTrustRecordKeyGenerator mfaTrustRecordKeyGenerator() {
            return new DefaultMultifactorAuthenticationTrustRecordKeyGenerator();
        }
    }
}

