/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.decoding.impl;

import com.google.common.base.Strings;
import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPPostDecoder;
import org.opensaml.saml.saml2.binding.decoding.impl.SimpleSignatureContext;
import org.slf4j.Logger;

public class HTTPPostSimpleSignDecoder
extends HTTPPostDecoder {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(HTTPPostSimpleSignDecoder.class);

    @Override
    @Nonnull
    @NotEmpty
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign";
    }

    @Override
    protected void populateBindingContext(@Nonnull MessageContext messageContext) {
        SAMLBindingContext bindingContext = (SAMLBindingContext)messageContext.ensureSubcontext(SAMLBindingContext.class);
        bindingContext.setBindingUri(this.getBindingURI());
        bindingContext.setBindingDescriptor(this.getBindingDescriptor());
        bindingContext.setHasBindingSignature(!Strings.isNullOrEmpty((String)this.getHttpServletRequest().getParameter("Signature")));
        bindingContext.setIntendedDestinationEndpointURIRequired(SAMLBindingSupport.isMessageSigned((MessageContext)messageContext));
    }

    @Override
    protected void doDecode() throws MessageDecodingException {
        super.doDecode();
        byte[] signedContent = this.getSignedContent();
        if (signedContent == null) {
            this.log.warn("Failed to build signed content data, signature evaluation will be skipped");
            return;
        }
        MessageContext messageContext = this.getMessageContext();
        assert (messageContext != null);
        ((SimpleSignatureContext)messageContext.ensureSubcontext(SimpleSignatureContext.class)).setSignedContent(signedContent);
    }

    @Nullable
    protected byte[] getSignedContent() throws MessageDecodingException {
        StringBuilder builder;
        HttpServletRequest request;
        block12: {
            request = this.getHttpServletRequest();
            builder = new StringBuilder();
            try {
                String paramValue;
                if (request.getParameter("SAMLRequest") != null) {
                    paramValue = request.getParameter("SAMLRequest");
                    assert (paramValue != null);
                    String samlMsg = new String(Base64Support.decode((String)paramValue), "UTF-8");
                    builder.append("SAMLRequest=" + samlMsg);
                    break block12;
                }
                if (request.getParameter("SAMLResponse") != null) {
                    paramValue = request.getParameter("SAMLResponse");
                    assert (paramValue != null);
                    String samlMsg = new String(Base64Support.decode((String)paramValue), "UTF-8");
                    builder.append("SAMLResponse=" + samlMsg);
                    break block12;
                }
                this.log.warn("Could not extract either a SAMLRequest or a SAMLResponse from the form control data");
                return null;
            }
            catch (UnsupportedEncodingException e) {
                this.log.error("UTF-8 encoding is not supported, this VM is not Java compliant");
                throw new MessageDecodingException("Unable to process message, UTF-8 encoding is not supported");
            }
            catch (DecodingException e) {
                this.log.error("Unable to Base64 decode either a SAMLRequest or a SAMLResponse from the form control data");
                throw new MessageDecodingException("Unable to Base64 decode either a SAMLRequest or a SAMLResponse from the form control data", (Exception)((Object)e));
            }
        }
        if (request.getParameter("RelayState") != null) {
            builder.append("&RelayState=" + request.getParameter("RelayState"));
        }
        if (request.getParameter("SigAlg") == null) {
            this.log.warn("Signature algorithm could not be extracted from request, cannot build simple signature content");
            return null;
        }
        builder.append("&SigAlg=" + request.getParameter("SigAlg"));
        String constructed = builder.toString();
        if (Strings.isNullOrEmpty((String)constructed)) {
            this.log.warn("Could not construct signed content string from form control data");
            return null;
        }
        this.log.debug("Constructed signed content string for HTTP-Post-SimpleSign {}", (Object)constructed);
        try {
            return constructed.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("UTF-8 encoding is not supported, this VM is not Java compliant");
            throw new MessageDecodingException("Unable to process message, UTF-8 encoding is not supported");
        }
    }
}

