/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Groupable;
import org.apache.syncope.core.persistence.api.entity.Relatable;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.event.EntityLifecycleEvent;
import org.apache.syncope.ext.openfga.client.ApiException;
import org.apache.syncope.ext.openfga.client.OpenFGAClient;
import org.apache.syncope.ext.openfga.client.OpenFGAClientFactory;
import org.apache.syncope.ext.openfga.client.model.AuthorizationModel;
import org.apache.syncope.ext.openfga.client.model.Metadata;
import org.apache.syncope.ext.openfga.client.model.ReadRequest;
import org.apache.syncope.ext.openfga.client.model.ReadRequestTupleKey;
import org.apache.syncope.ext.openfga.client.model.RelationMetadata;
import org.apache.syncope.ext.openfga.client.model.RelationReference;
import org.apache.syncope.ext.openfga.client.model.Tuple;
import org.apache.syncope.ext.openfga.client.model.TupleKey;
import org.apache.syncope.ext.openfga.client.model.TupleKeyWithoutCondition;
import org.apache.syncope.ext.openfga.client.model.TypeDefinition;
import org.apache.syncope.ext.openfga.client.model.Userset;
import org.apache.syncope.ext.openfga.client.model.WriteAuthorizationModelRequest;
import org.apache.syncope.ext.openfga.client.model.WriteAuthorizationModelResponse;
import org.apache.syncope.ext.openfga.client.model.WriteRequest;
import org.apache.syncope.ext.openfga.client.model.WriteRequestDeletes;
import org.apache.syncope.ext.openfga.client.model.WriteRequestWrites;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.event.TransactionalEventListener;

public class OpenFGAStoreManager {
    protected static final Logger LOG = LoggerFactory.getLogger(OpenFGAStoreManager.class);
    protected final OpenFGAClientFactory clientFactory;
    protected final RelationshipTypeDAO relationshipTypeDAO;

    protected static String anyMembership(AnyType anyType) {
        return anyType.getKey() + "_member";
    }

    protected static String type(String anyType) {
        return anyType + ":";
    }

    protected static String type(AnyType anyType) {
        return OpenFGAStoreManager.type(anyType.getKey());
    }

    protected static String id(Any any) {
        String string;
        String string2 = OpenFGAStoreManager.type(any.getType());
        if (any instanceof User) {
            User user = (User)any;
            string = user.getUsername();
        } else if (any instanceof Group) {
            Group group = (Group)any;
            string = group.getName();
        } else {
            string = any.getKey();
        }
        return string2 + string;
    }

    public OpenFGAStoreManager(OpenFGAClientFactory clientFactory, RelationshipTypeDAO relationshipTypeDAO) {
        this.clientFactory = clientFactory;
        this.relationshipTypeDAO = relationshipTypeDAO;
    }

    public void handle(OpenFGAClient openfgaClient, SyncDeltaType eventType, AnyType anyType) throws ApiException {
        AuthorizationModel authModel = openfgaClient.readLatestAuthorizationModel();
        openfgaClient.setAuthorizationModelId(authModel.getId());
        Optional<TypeDefinition> group = authModel.getTypeDefinitions().stream().filter(type -> AnyTypeKind.GROUP.name().equals(type.getType())).findFirst();
        boolean changed = false;
        switch (eventType) {
            case CREATE: {
                changed = authModel.getTypeDefinitions().add(new TypeDefinition().type(anyType.getKey()).relations(Map.of()));
                if (!changed) break;
                group.ifPresent(g -> {
                    g.putRelationsItem(OpenFGAStoreManager.anyMembership(anyType), new Userset()._this(Map.of()));
                    g.getMetadata().putRelationsItem(OpenFGAStoreManager.anyMembership(anyType), new RelationMetadata().addDirectlyRelatedUserTypesItem(new RelationReference().type(anyType.getKey())));
                });
                break;
            }
            case DELETE: {
                changed = authModel.getTypeDefinitions().removeIf(typeDefinition -> anyType.getKey().equals(typeDefinition.getType()));
                if (!changed) break;
                group.ifPresent(g -> {
                    g.getRelations().remove(OpenFGAStoreManager.anyMembership(anyType));
                    g.getMetadata().getRelations().remove(OpenFGAStoreManager.anyMembership(anyType));
                });
                break;
            }
        }
        if (changed) {
            LOG.debug("Authorization Model is to update on {} {}", (Object)eventType, (Object)anyType);
            WriteAuthorizationModelResponse response = openfgaClient.writeAuthorizationModel(new WriteAuthorizationModelRequest().schemaVersion(authModel.getSchemaVersion()).typeDefinitions(authModel.getTypeDefinitions()).conditions(authModel.getConditions()));
            openfgaClient.setAuthorizationModelId(response.getAuthorizationModelId());
        } else {
            LOG.debug("Authorization Model not to update on {} {}", (Object)eventType, (Object)anyType);
        }
    }

    public void handle(OpenFGAClient openfgaClient, SyncDeltaType eventType, RelationshipType relationshipType) throws ApiException {
        if (relationshipType.getLeftEndAnyType().equals((Object)relationshipType.getRightEndAnyType())) {
            return;
        }
        AuthorizationModel authModel = openfgaClient.readLatestAuthorizationModel();
        openfgaClient.setAuthorizationModelId(authModel.getId());
        TypeDefinition left = authModel.getTypeDefinitions().stream().filter(type -> relationshipType.getLeftEndAnyType().getKey().equals(type.getType())).findFirst().orElseGet(() -> new TypeDefinition().type(relationshipType.getLeftEndAnyType().getKey()));
        TypeDefinition right = authModel.getTypeDefinitions().stream().filter(type -> relationshipType.getRightEndAnyType().getKey().equals(type.getType())).findFirst().orElseGet(() -> new TypeDefinition().type(relationshipType.getRightEndAnyType().getKey()));
        authModel.getTypeDefinitions().removeIf(type -> left.getType().equals(type.getType()) || right.getType().equals(type.getType()));
        authModel.addTypeDefinitionsItem(left);
        authModel.addTypeDefinitionsItem(right);
        boolean changed = false;
        switch (eventType) {
            case CREATE: {
                right.putRelationsItem(relationshipType.getKey(), new Userset()._this(Map.of()));
                right.metadata(new Metadata().putRelationsItem(relationshipType.getKey(), new RelationMetadata().addDirectlyRelatedUserTypesItem(new RelationReference().type(left.getType()))));
                changed = true;
                break;
            }
            case DELETE: {
                changed = right.getRelations().remove(relationshipType.getKey()) != null && right.getMetadata().getRelations().remove(relationshipType.getKey()) != null;
                break;
            }
        }
        if (changed) {
            LOG.debug("Authorization Model is to update on {} {}", (Object)eventType, (Object)relationshipType);
            WriteAuthorizationModelResponse response = openfgaClient.writeAuthorizationModel(new WriteAuthorizationModelRequest().schemaVersion(authModel.getSchemaVersion()).typeDefinitions(authModel.getTypeDefinitions()).conditions(authModel.getConditions()));
            openfgaClient.setAuthorizationModelId(response.getAuthorizationModelId());
        } else {
            LOG.debug("Authorization Model not to update on {} {}", (Object)eventType, (Object)relationshipType);
        }
    }

    public void handle(OpenFGAClient openfgaClient, SyncDeltaType eventType, Any any) throws ApiException {
        List<TupleKey> next;
        ArrayList<Object> readRequests = new ArrayList<Object>();
        if (any instanceof Groupable) {
            ReadRequest request = new ReadRequest();
            request.setTupleKey(new ReadRequestTupleKey().user(OpenFGAStoreManager.id(any))._object(OpenFGAStoreManager.type(AnyTypeKind.GROUP.name())));
            readRequests.add(request);
        }
        for (Object relationshipType : this.relationshipTypeDAO.findByLeftEndAnyType(any.getType())) {
            ReadRequest readRequest = new ReadRequest();
            readRequest.setTupleKey(new ReadRequestTupleKey().user(OpenFGAStoreManager.id(any))._object(OpenFGAStoreManager.type(relationshipType.getRightEndAnyType())));
            readRequests.add(readRequest);
        }
        ArrayList<TupleKey> current = new ArrayList<TupleKey>();
        for (ReadRequest readRequest : readRequests) {
            current.addAll(openfgaClient.read(readRequest).getTuples().stream().map(Tuple::getKey).toList());
        }
        if (eventType == SyncDeltaType.DELETE) {
            next = List.of();
        } else {
            next = new ArrayList();
            if (any instanceof Groupable) {
                Groupable groupable = (Groupable)any;
                next.addAll(groupable.getMemberships().stream().map(m -> new TupleKey().user(OpenFGAStoreManager.id((Any)groupable)).relation("member")._object(OpenFGAStoreManager.id(m.getRightEnd()))).toList());
            }
            if (any instanceof Relatable) {
                Relatable relatable = (Relatable)any;
                next.addAll(relatable.getRelationships().stream().filter(r -> !r.getType().getRightEndAnyType().equals((Object)any.getType())).map(r -> new TupleKey().user(OpenFGAStoreManager.id((Any)relatable)).relation(r.getType().getKey())._object(OpenFGAStoreManager.id(r.getRightEnd()))).toList());
            }
        }
        List<TupleKey> list = next.stream().filter(tk -> !current.contains(tk)).map(tk -> new TupleKey().user(tk.getUser()).relation(tk.getRelation())._object(tk.getObject())).toList();
        List<TupleKeyWithoutCondition> toDelete = current.stream().filter(tk -> !next.contains(tk)).map(tk -> new TupleKeyWithoutCondition().user(tk.getUser()).relation(tk.getRelation())._object(tk.getObject())).toList();
        if (!list.isEmpty() || !toDelete.isEmpty()) {
            LOG.debug("Tuples are to update on {} {}", (Object)eventType, (Object)any);
            AuthorizationModel authModel = openfgaClient.readLatestAuthorizationModel();
            openfgaClient.setAuthorizationModelId(authModel.getId());
            WriteRequest request = new WriteRequest();
            if (!list.isEmpty()) {
                request.writes(new WriteRequestWrites().tupleKeys(list));
            }
            if (!toDelete.isEmpty()) {
                request.deletes(new WriteRequestDeletes().tupleKeys(toDelete));
            }
            openfgaClient.write(request);
        } else {
            LOG.debug("Tuples not to update on {} {}", (Object)eventType, (Object)any);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    @TransactionalEventListener
    public void entity(EntityLifecycleEvent<Entity> event) throws IOException {
        LOG.debug("About to handle {}", event);
        OpenFGAClient openfgaClient = this.clientFactory.get(event.getDomain());
        try {
            AnyType anyType;
            Entity entity = event.getEntity();
            if (entity instanceof AnyType && (anyType = (AnyType)entity).getKind() == AnyTypeKind.ANY_OBJECT) {
                this.handle(openfgaClient, event.getType(), anyType);
            } else {
                entity = event.getEntity();
                if (entity instanceof RelationshipType) {
                    RelationshipType relationshipType = (RelationshipType)entity;
                    this.handle(openfgaClient, event.getType(), relationshipType);
                } else {
                    entity = event.getEntity();
                    if (entity instanceof Any) {
                        Any any = (Any)entity;
                        this.handle(openfgaClient, event.getType(), any);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("While handling event {}", event, (Object)e);
        }
    }
}

