/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.engine.model.AbstractModel;
import org.springframework.webflow.engine.model.Model;

public class VarModel
extends AbstractModel {
    private String name;
    private String className;

    public VarModel(String name, String className) {
        this.setName(name);
        this.setClassName(className);
    }

    @Override
    public boolean isMergeableWith(Model model) {
        if (!(model instanceof VarModel)) {
            return false;
        }
        VarModel var = (VarModel)model;
        return ObjectUtils.nullSafeEquals((Object)this.getName(), (Object)var.getName());
    }

    @Override
    public void merge(Model model) {
        VarModel var = (VarModel)model;
        this.setClassName(this.merge(this.getClassName(), var.getClassName()));
    }

    @Override
    public Model createCopy() {
        return new VarModel(this.name, this.className);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtils.hasText((String)name) ? name : null;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = StringUtils.hasText((String)className) ? className : null;
    }
}

