/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import kafka.api.AbstractConsumerTest;
import kafka.api.BaseConsumerTest$;
import kafka.server.KafkaBroker;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001de!B\f\u0019\u0003\u0003i\u0002\"\u0002\u0012\u0001\t\u0003\u0019\u0003\"B\u0013\u0001\t\u00031\u0003\"B,\u0001\t\u0003A\u0006\"\u00020\u0001\t\u0003yv!B3\u0019\u0011\u00031g!B\f\u0019\u0011\u00039\u0007\"\u0002\u0012\u0007\t\u0003Y\u0007\"\u0002,\u0007\t\u0003a\u0007\"\u0002>\u0007\t\u0003a\u0007\"B>\u0007\t\u0003a\u0007b\u0002?\u0007\u0005\u0004%\t! \u0005\b\u0003\u001b1\u0001\u0015!\u0003\u007f\u0011!\tyA\u0002b\u0001\n\u0003i\bbBA\t\r\u0001\u0006IA \u0004\u0007\u0003'1\u0001!!\u0006\t\r\tzA\u0011AA'\u0011\u001d\t\u0019f\u0004C!\u0003+Bq!!\u0019\u0010\t\u0003\n\u0019G\u0002\u0004\u0002n\u0019\u0001\u0011q\u000e\u0005\u0007EM!\t!a\u001e\t\u000f\u0005M3\u0003\"\u0011\u0002|!9\u0011qP\n\u0005B\u0005\u0005%\u0001\u0005\"bg\u0016\u001cuN\\:v[\u0016\u0014H+Z:u\u0015\tI\"$A\u0002ba&T\u0011aG\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u0004\u0005\u0002 A5\t\u0001$\u0003\u0002\"1\t!\u0012IY:ue\u0006\u001cGoQ8ogVlWM\u001d+fgR\fa\u0001P5oSRtD#\u0001\u0013\u0011\u0005}\u0001\u0011!\u0006;fgR\u001c\u0016.\u001c9mK\u000e{gn];naRLwN\u001c\u000b\u0004O5R\u0004C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#\u0001B+oSRDQA\f\u0002A\u0002=\na!];peVl\u0007C\u0001\u00198\u001d\t\tT\u0007\u0005\u00023S5\t1G\u0003\u000259\u00051AH]8pizJ!AN\u0015\u0002\rA\u0013X\rZ3g\u0013\tA\u0014H\u0001\u0004TiJLgn\u001a\u0006\u0003m%BQa\u000f\u0002A\u0002=\nQb\u001a:pkB\u0004&o\u001c;pG>d\u0007\u0006\u0002\u0002>\u0013*\u0003\"AP$\u000e\u0003}R!\u0001Q!\u0002\rA\f'/Y7t\u0015\t\u00115)A\u0004kkBLG/\u001a:\u000b\u0005\u0011+\u0015!\u00026v]&$(\"\u0001$\u0002\u0007=\u0014x-\u0003\u0002I\u007f\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0002\u0017\u0006Q3\u0010Z5ta2\f\u0017PT1nKvt\u0013/^8sk6l4\u0010M?/OJ|W\u000f\u001d)s_R|7m\u001c7>wFj\b\u0006\u0002\u0002N'R\u0003\"AT)\u000e\u0003=S!\u0001U \u0002\u0011A\u0014xN^5eKJL!AU(\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0003U\u000b\u0013AV\u0001+O\u0016$H+Z:u#V|'/^7B]\u0012<%o\\;q!J|Go\\2pYB\u000b'/Y7fi\u0016\u00148/\u00117m\u0003m!Xm\u001d;DYV\u001cH/\u001a:SKN|WO]2f\u0019&\u001cH/\u001a8feR\u0019q%\u0017.\t\u000b9\u001a\u0001\u0019A\u0018\t\u000bm\u001a\u0001\u0019A\u0018)\t\ri\u0014J\u0013\u0015\u0005\u00075\u001bV\fL\u0001V\u0003]!Xm\u001d;D_>\u0014H-\u001b8bi>\u0014h)Y5m_Z,'\u000fF\u0002(A\u0006DQA\f\u0003A\u0002=BQa\u000f\u0003A\u0002=BC\u0001B\u001fJ\u0015\"\"A!T*eY\u0005)\u0016\u0001\u0005\"bg\u0016\u001cuN\\:v[\u0016\u0014H+Z:u!\tyba\u0005\u0002\u0007QB\u0011\u0001&[\u0005\u0003U&\u0012a!\u00118z%\u00164G#\u00014\u0015\u00035\u00042A\\;x\u001b\u0005y'B\u00019r\u0003\u0019\u0019HO]3b[*\u0011!o]\u0001\u0005kRLGNC\u0001u\u0003\u0011Q\u0017M^1\n\u0005Y|'AB*ue\u0016\fW\u000e\u0005\u0002Oq&\u0011\u0011p\u0014\u0002\n\u0003J<W/\\3oiN\fqhZ3u)\u0016\u001cH/U;peVl\u0017I\u001c3He>,\b\u000f\u0015:pi>\u001cw\u000e\u001c)be\u0006lW\r^3sg\u000ec\u0017m]:jG\u001e\u0013x.\u001e9Qe>$xnY8m\u001f:d\u00170\u0001!hKR$Vm\u001d;Rk>\u0014X/\\!oI\u001e\u0013x.\u001e9Qe>$xnY8m!\u0006\u0014\u0018-\\3uKJ\u001c8i\u001c8tk6,'o\u0012:pkB\u0004&o\u001c;pG>dwJ\u001c7z\u0003M)\b\u000fZ1uKB\u0013x\u000eZ;dKJ\u001cu.\u001e8u+\u0005q\bcA@\u0002\n5\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!\u0001\u0004bi>l\u0017n\u0019\u0006\u0004\u0003\u000f\t\u0018AC2p]\u000e,(O]3oi&!\u00111BA\u0001\u00055\tEo\\7jG&sG/Z4fe\u0006!R\u000f\u001d3bi\u0016\u0004&o\u001c3vG\u0016\u00148i\\;oi\u0002\n1#\u001e9eCR,7i\u001c8tk6,'oQ8v]R\fA#\u001e9eCR,7i\u001c8tk6,'oQ8v]R\u0004#!\n+fgR\u001cE.^:uKJ\u0014Vm]8ve\u000e,G*[:uK:,'oU3sS\u0006d\u0017N_3s'\u001dy\u0011qCA\u0012\u0003\u000b\u0002B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;\u0019\u0018\u0001\u00027b]\u001eLA!!\t\u0002\u001c\t1qJ\u00196fGR\u0004b!!\n\u00026\u0005eRBAA\u0014\u0015\u0011\tI#a\u000b\u0002\u001bM,'/[1mSj\fG/[8o\u0015\u0011\ti#a\f\u0002\r\r|W.\\8o\u0015\rY\u0012\u0011\u0007\u0006\u0004\u0003g)\u0015AB1qC\u000eDW-\u0003\u0003\u00028\u0005\u001d\"AC*fe&\fG.\u001b>feB)\u0001&a\u000f\u0002@%\u0019\u0011QH\u0015\u0003\u000b\u0005\u0013(/Y=\u0011\u0007!\n\t%C\u0002\u0002D%\u0012AAQ=uKB!\u0011qIA%\u001b\t\tY#\u0003\u0003\u0002L\u0005-\"aF\"mkN$XM\u001d*fg>,(oY3MSN$XM\\3s)\t\ty\u0005E\u0002\u0002R=i\u0011AB\u0001\t_:,\u0006\u000fZ1uKR\u0019q%a\u0016\t\u000f\u0005e\u0013\u00031\u0001\u0002\\\u0005y1\r\\;ti\u0016\u0014(+Z:pkJ\u001cW\r\u0005\u0003\u0002H\u0005u\u0013\u0002BA0\u0003W\u0011qb\u00117vgR,'OU3t_V\u00148-Z\u0001\ng\u0016\u0014\u0018.\u00197ju\u0016$b!!\u000f\u0002f\u0005%\u0004BBA4%\u0001\u0007q&A\u0003u_BL7\rC\u0004\u0002lI\u0001\r!!\u000f\u0002\t\u0011\fG/\u0019\u0002()\u0016\u001cHo\u00117vgR,'OU3t_V\u00148-\u001a'jgR,g.\u001a:EKN,'/[1mSj,'oE\u0004\u0014\u0003/\t\t(!\u0012\u0011\r\u0005\u0015\u00121OA\u001d\u0013\u0011\t)(a\n\u0003\u0019\u0011+7/\u001a:jC2L'0\u001a:\u0015\u0005\u0005e\u0004cAA)'Q\u0019q%! \t\u000f\u0005eS\u00031\u0001\u0002\\\u0005YA-Z:fe&\fG.\u001b>f)\u0019\tI$a!\u0002\u0006\"1\u0011q\r\fA\u0002=Bq!a\u001b\u0017\u0001\u0004\tI\u0004")
public abstract class BaseConsumerTest
extends AbstractConsumerTest {
    public static AtomicInteger updateConsumerCount() {
        return BaseConsumerTest$.MODULE$.updateConsumerCount();
    }

    public static AtomicInteger updateProducerCount() {
        return BaseConsumerTest$.MODULE$.updateProducerCount();
    }

    public static Stream<Arguments> getTestQuorumAndGroupProtocolParametersConsumerGroupProtocolOnly() {
        return BaseConsumerTest$.MODULE$.getTestQuorumAndGroupProtocolParametersConsumerGroupProtocolOnly();
    }

    public static Stream<Arguments> getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly() {
        return BaseConsumerTest$.MODULE$.getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly();
    }

    public static Stream<Arguments> getTestQuorumAndGroupProtocolParametersAll() {
        return BaseConsumerTest$.MODULE$.getTestQuorumAndGroupProtocolParametersAll();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testSimpleConsumption(String quorum, String groupProtocol) {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((int)1, (int)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$5, startingTimestamp, x$6, x$7, x$8);
        this.sendAndAwaitAsyncCommit(consumer, this.sendAndAwaitAsyncCommit$default$2());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testClusterResourceListener(String quorum, String groupProtocol) {
        int numRecords = 100;
        Properties producerProps = new Properties();
        producerProps.put("key.serializer", TestClusterResourceListenerSerializer.class);
        producerProps.put("value.serializer", TestClusterResourceListenerSerializer.class);
        KafkaProducer producer = this.createProducer(null, null, producerProps);
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        Properties consumerProps = new Properties();
        consumerProps.put("key.deserializer", TestClusterResourceListenerDeserializer.class);
        consumerProps.put("value.deserializer", TestClusterResourceListenerDeserializer.class);
        Consumer consumer = this.createConsumer(null, null, consumerProps, this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp().topic(), (List)Nil$.MODULE$)).asJava());
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$5, startingTimestamp, x$6, x$7, x$8);
        Assertions.assertNotEquals((int)0, (int)BaseConsumerTest$.MODULE$.updateProducerCount().get());
        Assertions.assertNotEquals((int)0, (int)BaseConsumerTest$.MODULE$.updateConsumerCount().get());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testCoordinatorFailover(String quorum, String groupProtocol) {
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener(this);
        this.consumerConfig().setProperty("session.timeout.ms", "5001");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("max.poll.interval.ms", "15000");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned());
        Buffer parts = null;
        while (parts == null) {
            parts = CollectionConverters$.MODULE$.ListHasAsScala(consumer.partitionsFor("__consumer_offsets")).asScala();
        }
        Assertions.assertEquals((int)1, (int)parts.size());
        Assertions.assertNotNull((Object)((PartitionInfo)parts.head()).leader());
        int coordinator = ((PartitionInfo)parts.head()).leader().id();
        ((KafkaBroker)this.brokers().apply(coordinator)).shutdown();
        this.ensureNoRebalance(consumer, listener);
    }

    public static class TestClusterResourceListenerDeserializer
    implements Deserializer<byte[]>,
    ClusterResourceListener {
        public void configure(Map<String, ?> x$1, boolean x$2) {
            super.configure(x$1, x$2);
        }

        public Object deserialize(String x$1, Headers x$2, byte[] x$3) {
            return super.deserialize(x$1, x$2, x$3);
        }

        public Object deserialize(String x$1, Headers x$2, ByteBuffer x$3) {
            return super.deserialize(x$1, x$2, x$3);
        }

        public void close() {
            super.close();
        }

        public void onUpdate(ClusterResource clusterResource) {
            BaseConsumerTest$.MODULE$.updateConsumerCount().incrementAndGet();
        }

        public byte[] deserialize(String topic, byte[] data) {
            return data;
        }
    }

    public static class TestClusterResourceListenerSerializer
    implements Serializer<byte[]>,
    ClusterResourceListener {
        public void configure(Map<String, ?> x$1, boolean x$2) {
            super.configure(x$1, x$2);
        }

        public byte[] serialize(String x$1, Headers x$2, Object x$3) {
            return super.serialize(x$1, x$2, x$3);
        }

        public void close() {
            super.close();
        }

        public void onUpdate(ClusterResource clusterResource) {
            BaseConsumerTest$.MODULE$.updateProducerCount().incrementAndGet();
        }

        public byte[] serialize(String topic, byte[] data) {
            return data;
        }
    }
}

