/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldap.commons;

import java.util.Collections;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import net.tirasa.connid.bundles.ldap.commons.StatusManagement;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.objects.AttributeDelta;
import org.identityconnectors.framework.common.objects.AttributeDeltaBuilder;

public class AttributeStatusManagement
extends StatusManagement {
    private static final Log LOG = Log.getLog(AttributeStatusManagement.class);

    protected String getStatusAttrName() {
        return "description";
    }

    protected String getStatusAttrActiveValue() {
        return "Active";
    }

    protected String getStatusAttrInactiveValue() {
        return "Inactive";
    }

    @Override
    public void setStatus(boolean status, Attributes attributes) {
        LOG.ok("Calling setStatus {0}", new Object[]{status});
        Attribute statusAttr = attributes.get(this.getStatusAttrName());
        if (statusAttr == null) {
            statusAttr = new BasicAttribute(this.getStatusAttrName());
            attributes.put(statusAttr);
        }
        statusAttr.add(status ? this.getStatusAttrActiveValue() : this.getStatusAttrInactiveValue());
    }

    @Override
    public void setStatus(boolean status, Set<AttributeDelta> modifications) {
        LOG.ok("Calling setStatus {0}", new Object[]{status});
        modifications.add(AttributeDeltaBuilder.build((String)this.getStatusAttrName(), (Object[])new Object[]{status ? this.getStatusAttrActiveValue() : this.getStatusAttrInactiveValue()}));
    }

    @Override
    public Boolean getStatus(Attributes attributes) {
        Boolean status = Boolean.TRUE;
        Attribute statusAttr = attributes.get(this.getStatusAttrName());
        if (statusAttr != null) {
            try {
                Object value = statusAttr.get();
                if (value != null) {
                    status = this.getStatusAttrActiveValue().equals(value.toString());
                }
            }
            catch (NamingException ignore) {
                status = null;
            }
        }
        LOG.ok("Returning getStatus {0}", new Object[]{status});
        return status;
    }

    @Override
    public Set<String> getOperationalAttributes() {
        return Collections.singleton(this.getStatusAttrName());
    }
}

