/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AnyMatchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.anyobject.ADynGroupMembership;
import org.apache.syncope.core.persistence.api.entity.anyobject.AMembership;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.group.TypeExtension;
import org.apache.syncope.core.persistence.api.entity.user.UDynGroupMembership;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.search.SearchCondConverter;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.persistence.api.utils.RealmUtils;
import org.apache.syncope.core.persistence.common.dao.AnyFinder;
import org.apache.syncope.core.persistence.jpa.dao.repo.AbstractAnyRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.GroupRepoExt;
import org.apache.syncope.core.persistence.jpa.entity.anyobject.JPAADynGroupMembership;
import org.apache.syncope.core.persistence.jpa.entity.anyobject.JPAAMembership;
import org.apache.syncope.core.persistence.jpa.entity.group.JPAGroup;
import org.apache.syncope.core.persistence.jpa.entity.group.JPATypeExtension;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUDynGroupMembership;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUMembership;
import org.apache.syncope.core.provisioning.api.event.EntityLifecycleEvent;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public class GroupRepoExtImpl
extends AbstractAnyRepoExt<Group>
implements GroupRepoExt {
    protected final ApplicationEventPublisher publisher;
    protected final AnyMatchDAO anyMatchDAO;
    protected final UserDAO userDAO;
    protected final AnyObjectDAO anyObjectDAO;
    protected final AnySearchDAO anySearchDAO;
    protected final SearchCondVisitor searchCondVisitor;

    public GroupRepoExtImpl(AnyUtilsFactory anyUtilsFactory, ApplicationEventPublisher publisher, DynRealmDAO dynRealmDAO, PlainSchemaDAO plainSchemaDAO, AnyMatchDAO anyMatchDAO, UserDAO userDAO, AnyObjectDAO anyObjectDAO, AnySearchDAO searchDAO, SearchCondVisitor searchCondVisitor, EntityManager entityManager, AnyFinder anyFinder) {
        super(dynRealmDAO, plainSchemaDAO, entityManager, anyFinder, anyUtilsFactory.getInstance(AnyTypeKind.GROUP));
        this.publisher = publisher;
        this.anyMatchDAO = anyMatchDAO;
        this.userDAO = userDAO;
        this.anyObjectDAO = anyObjectDAO;
        this.anySearchDAO = searchDAO;
        this.searchCondVisitor = searchCondVisitor;
    }

    @Override
    @Transactional(readOnly=true)
    public void securityChecks(Set<String> authRealms, String key, String realm) {
        boolean authorized = authRealms.stream().anyMatch(authRealm -> realm.startsWith((String)authRealm) || authRealm.equals(RealmUtils.getGroupOwnerRealm((String)realm, (String)key)));
        if (!authorized && key != null) {
            authorized = this.findDynRealms(key).stream().anyMatch(authRealms::contains);
        }
        if (authRealms.isEmpty() || !authorized) {
            throw new DelegatedAdministrationException(realm, AnyTypeKind.GROUP.name(), key);
        }
    }

    @Override
    protected void securityChecks(Group group) {
        Set<String> authRealms = AuthContextUtils.getAuthorizations().getOrDefault("GROUP_READ", Set.of());
        this.securityChecks(authRealms, group.getKey(), group.getRealm().getFullPath());
    }

    @Override
    public Map<String, Long> countByRealm() {
        Query query = this.entityManager.createQuery("SELECT e.realm, COUNT(e) FROM " + this.anyUtils.anyClass().getSimpleName() + " e GROUP BY e.realm");
        List results = query.getResultList();
        return results.stream().collect(Collectors.toMap(result -> ((Realm)result[0]).getFullPath(), result -> ((Number)result[1]).longValue()));
    }

    @Override
    @Transactional(readOnly=true)
    public List<Group> findOwnedByUser(String userKey) {
        User owner = this.userDAO.findById(userKey).orElse(null);
        if (owner == null) {
            return List.of();
        }
        StringBuilder queryString = new StringBuilder("SELECT e FROM ").append(this.anyUtils.anyClass().getSimpleName()).append(" e WHERE e.userOwner=:owner ");
        this.userDAO.findAllGroupKeys(owner).forEach(groupKey -> queryString.append("OR e.groupOwner.id='").append((String)groupKey).append("' "));
        TypedQuery query = this.entityManager.createQuery(queryString.toString(), Group.class);
        query.setParameter("owner", (Object)owner);
        return query.getResultList();
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<String> findAllResourceKeys(String key) {
        return this.findById(key).map(Any::getResources).orElseGet(List::of).stream().map(Entity::getKey).toList();
    }

    @Override
    @Transactional(readOnly=true)
    public boolean existsAMembership(String anyObjectKey, String groupKey) {
        Query query = this.entityManager.createNativeQuery("SELECT COUNT(*) FROM AMembership WHERE group_id=? AND anyobject_it=?");
        query.setParameter(1, (Object)groupKey);
        query.setParameter(2, (Object)anyObjectKey);
        return ((Number)query.getSingleResult()).longValue() > 0L;
    }

    @Override
    @Transactional(readOnly=true)
    public boolean existsUMembership(String userKey, String groupKey) {
        Query query = this.entityManager.createNativeQuery("SELECT COUNT(*) FROM UMembership WHERE group_id=? AND user_id=?");
        query.setParameter(1, (Object)groupKey);
        query.setParameter(2, (Object)userKey);
        return ((Number)query.getSingleResult()).longValue() > 0L;
    }

    @Override
    public List<AMembership> findAMemberships(Group group) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAAMembership.class.getSimpleName() + " e WHERE e.rightEnd=:group", AMembership.class);
        query.setParameter("group", (Object)group);
        return query.getResultList();
    }

    @Override
    public List<UMembership> findUMemberships(Group group, Pageable pageable) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAUMembership.class.getSimpleName() + " e WHERE e.rightEnd=:group ORDER BY e.leftEnd", UMembership.class);
        query.setParameter("group", (Object)group);
        if (pageable.isPaged()) {
            query.setFirstResult(pageable.getPageSize() * pageable.getPageNumber());
            query.setMaxResults(pageable.getPageSize());
        }
        return query.getResultList();
    }

    @Override
    public <S extends Group> S save(S group) {
        this.checkBeforeSave((JPAGroup)group);
        return (S)((Group)this.entityManager.merge(group));
    }

    @Override
    public Group saveAndRefreshDynMemberships(Group group) {
        Group merged = this.save(group);
        this.clearUDynMembers(merged);
        if (merged.getUDynMembership() != null) {
            SearchCond cond = SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)merged.getUDynMembership().getFIQLCond(), (String[])new String[0]);
            long count = this.anySearchDAO.count(merged.getRealm(), true, Set.of(merged.getRealm().getFullPath()), cond, AnyTypeKind.USER);
            int page = 0;
            while ((long)page <= count / 500L) {
                List matching = this.anySearchDAO.search(merged.getRealm(), true, Set.of(merged.getRealm().getFullPath()), cond, (Pageable)PageRequest.of((int)page, (int)500), AnyTypeKind.USER);
                matching.forEach(user -> {
                    Query insert = this.entityManager.createNativeQuery("INSERT INTO UDynGroupMembers VALUES(?, ?)");
                    insert.setParameter(1, (Object)user.getKey());
                    insert.setParameter(2, (Object)merged.getKey());
                    insert.executeUpdate();
                    this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)user, AuthContextUtils.getDomain()));
                });
                ++page;
            }
        }
        this.clearADynMembers(merged);
        merged.getADynMemberships().forEach(memb -> {
            SearchCond cond = SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)memb.getFIQLCond(), (String[])new String[0]);
            long count = this.anySearchDAO.count(merged.getRealm(), true, Set.of(merged.getRealm().getFullPath()), cond, AnyTypeKind.ANY_OBJECT);
            int page = 0;
            while ((long)page <= count / 500L) {
                List matching = this.anySearchDAO.search(merged.getRealm(), true, Set.of(merged.getRealm().getFullPath()), cond, (Pageable)PageRequest.of((int)page, (int)500), AnyTypeKind.ANY_OBJECT);
                matching.forEach(any -> {
                    Query insert = this.entityManager.createNativeQuery("INSERT INTO ADynGroupMembers VALUES(?, ?, ?)");
                    insert.setParameter(1, (Object)any.getType().getKey());
                    insert.setParameter(2, (Object)any.getKey());
                    insert.setParameter(3, (Object)merged.getKey());
                    insert.executeUpdate();
                    this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)any, AuthContextUtils.getDomain()));
                });
                ++page;
            }
        });
        this.dynRealmDAO.refreshDynMemberships((Any)merged);
        return merged;
    }

    @Override
    public void delete(Group group) {
        this.dynRealmDAO.removeDynMemberships(group.getKey());
        this.findAMemberships(group).forEach(membership -> {
            AnyObject leftEnd = (AnyObject)membership.getLeftEnd();
            leftEnd.remove((Membership)membership);
            membership.setRightEnd(null);
            leftEnd.getPlainAttrs((Membership)membership).forEach(arg_0 -> ((AnyObject)leftEnd).remove(arg_0));
            this.anyObjectDAO.save((Entity)leftEnd);
            this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)leftEnd, AuthContextUtils.getDomain()));
        });
        this.findUMemberships(group, Pageable.unpaged()).forEach(membership -> {
            User leftEnd = (User)membership.getLeftEnd();
            leftEnd.remove((Membership)membership);
            membership.setRightEnd(null);
            leftEnd.getPlainAttrs((Membership)membership).forEach(arg_0 -> ((User)leftEnd).remove(arg_0));
            this.userDAO.save((Entity)leftEnd);
            this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)leftEnd, AuthContextUtils.getDomain()));
        });
        this.clearUDynMembers(group);
        this.clearADynMembers(group);
        this.entityManager.remove((Object)group);
    }

    @Override
    public List<TypeExtension> findTypeExtensions(AnyTypeClass anyTypeClass) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPATypeExtension.class.getSimpleName() + " e WHERE :anyTypeClass MEMBER OF e.auxClasses", TypeExtension.class);
        query.setParameter("anyTypeClass", (Object)anyTypeClass);
        return query.getResultList();
    }

    @Override
    public long countADynMembers(Group group) {
        Query query = this.entityManager.createNativeQuery("SELECT COUNT(DISTINCT any_id) FROM ADynGroupMembers WHERE group_id=?");
        query.setParameter(1, (Object)group.getKey());
        return ((Number)query.getSingleResult()).longValue();
    }

    @Override
    public long countUDynMembers(Group group) {
        if (group.getUDynMembership() == null) {
            return 0L;
        }
        Query query = this.entityManager.createNativeQuery("SELECT COUNT(DISTINCT any_id) FROM UDynGroupMembers WHERE group_id=?");
        query.setParameter(1, (Object)group.getKey());
        return ((Number)query.getSingleResult()).longValue();
    }

    @Override
    @Transactional(readOnly=true)
    public List<String> findADynMembers(Group group) {
        ArrayList<String> result = new ArrayList<String>();
        group.getADynMemberships().forEach(memb -> {
            Query query = this.entityManager.createNativeQuery("SELECT DISTINCT any_id FROM ADynGroupMembers WHERE group_id=? AND anyType_id=?");
            query.setParameter(1, (Object)group.getKey());
            query.setParameter(2, (Object)memb.getAnyType().getKey());
            List queryResult = query.getResultList();
            result.addAll(queryResult.stream().map(Object::toString).filter(anyObject -> !result.contains(anyObject)).toList());
        });
        return result;
    }

    @Override
    public List<String> findUDynMembers(Group group) {
        if (group.getUDynMembership() == null) {
            return List.of();
        }
        Query query = this.entityManager.createNativeQuery("SELECT DISTINCT any_id FROM UDynGroupMembers WHERE group_id=?");
        query.setParameter(1, (Object)group.getKey());
        List result = query.getResultList();
        return result.stream().map(Object::toString).toList();
    }

    @Override
    public void clearADynMembers(Group group) {
        Query delete = this.entityManager.createNativeQuery("DELETE FROM ADynGroupMembers WHERE group_id=?");
        delete.setParameter(1, (Object)group.getKey());
        delete.executeUpdate();
    }

    @Override
    public void clearUDynMembers(Group group) {
        Query delete = this.entityManager.createNativeQuery("DELETE FROM UDynGroupMembers WHERE group_id=?");
        delete.setParameter(1, (Object)group.getKey());
        delete.executeUpdate();
    }

    protected List<ADynGroupMembership> findWithADynMemberships(AnyType anyType) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAADynGroupMembership.class.getSimpleName() + " e  WHERE e.anyType=:anyType", ADynGroupMembership.class);
        query.setParameter("anyType", (Object)anyType);
        return query.getResultList();
    }

    @Override
    @Transactional
    public Pair<Set<String>, Set<String>> refreshDynMemberships(AnyObject anyObject) {
        HashSet before = new HashSet();
        HashSet after = new HashSet();
        this.findWithADynMemberships(anyObject.getType()).forEach(memb -> {
            boolean existing;
            boolean matches = this.anyMatchDAO.matches((Any)anyObject, SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)memb.getFIQLCond(), (String[])new String[0]));
            if (matches) {
                after.add(memb.getGroup().getKey());
            }
            Query query = this.entityManager.createNativeQuery("SELECT COUNT(group_id) FROM ADynGroupMembers WHERE group_id=? AND any_id=?");
            query.setParameter(1, (Object)memb.getGroup().getKey());
            query.setParameter(2, (Object)anyObject.getKey());
            boolean bl = existing = ((Number)query.getSingleResult()).longValue() > 0L;
            if (existing) {
                before.add(memb.getGroup().getKey());
            }
            if (matches && !existing) {
                Query insert = this.entityManager.createNativeQuery("INSERT INTO ADynGroupMembers VALUES(?, ?, ?)");
                insert.setParameter(1, (Object)anyObject.getType().getKey());
                insert.setParameter(2, (Object)anyObject.getKey());
                insert.setParameter(3, (Object)memb.getGroup().getKey());
                insert.executeUpdate();
            } else if (!matches && existing) {
                Query delete = this.entityManager.createNativeQuery("DELETE FROM ADynGroupMembers WHERE group_id=? AND any_id=?");
                delete.setParameter(1, (Object)memb.getGroup().getKey());
                delete.setParameter(2, (Object)anyObject.getKey());
                delete.executeUpdate();
            }
            this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)memb.getGroup(), AuthContextUtils.getDomain()));
        });
        return Pair.of(before, after);
    }

    @Override
    public Set<String> removeDynMemberships(AnyObject anyObject) {
        List dynGroups = this.anyObjectDAO.findDynGroups(anyObject.getKey());
        Query delete = this.entityManager.createNativeQuery("DELETE FROM ADynGroupMembers WHERE any_id=?");
        delete.setParameter(1, (Object)anyObject.getKey());
        delete.executeUpdate();
        HashSet<String> before = new HashSet<String>();
        dynGroups.forEach(group -> {
            before.add(group.getKey());
            this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)group, AuthContextUtils.getDomain()));
        });
        return before;
    }

    protected List<UDynGroupMembership> findWithUDynMemberships() {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAUDynGroupMembership.class.getSimpleName() + " e", UDynGroupMembership.class);
        return query.getResultList();
    }

    @Override
    @Transactional
    public Pair<Set<String>, Set<String>> refreshDynMemberships(User user) {
        HashSet before = new HashSet();
        HashSet after = new HashSet();
        this.findWithUDynMemberships().forEach(memb -> {
            boolean existing;
            boolean matches = this.anyMatchDAO.matches((Any)user, SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)memb.getFIQLCond(), (String[])new String[0]));
            if (matches) {
                after.add(memb.getGroup().getKey());
            }
            Query query = this.entityManager.createNativeQuery("SELECT COUNT(group_id) FROM UDynGroupMembers WHERE group_id=? AND any_id=?");
            query.setParameter(1, (Object)memb.getGroup().getKey());
            query.setParameter(2, (Object)user.getKey());
            boolean bl = existing = ((Number)query.getSingleResult()).longValue() > 0L;
            if (existing) {
                before.add(memb.getGroup().getKey());
            }
            if (matches && !existing) {
                Query insert = this.entityManager.createNativeQuery("INSERT INTO UDynGroupMembers VALUES(?, ?)");
                insert.setParameter(1, (Object)user.getKey());
                insert.setParameter(2, (Object)memb.getGroup().getKey());
                insert.executeUpdate();
            } else if (!matches && existing) {
                Query delete = this.entityManager.createNativeQuery("DELETE FROM UDynGroupMembers WHERE group_id=? AND any_id=?");
                delete.setParameter(1, (Object)memb.getGroup().getKey());
                delete.setParameter(2, (Object)user.getKey());
                delete.executeUpdate();
            }
            this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)memb.getGroup(), AuthContextUtils.getDomain()));
        });
        return Pair.of(before, after);
    }

    @Override
    public Set<String> removeDynMemberships(User user) {
        List dynGroups = this.userDAO.findDynGroups(user.getKey());
        Query delete = this.entityManager.createNativeQuery("DELETE FROM UDynGroupMembers WHERE any_id=?");
        delete.setParameter(1, (Object)user.getKey());
        delete.executeUpdate();
        HashSet<String> before = new HashSet<String>();
        dynGroups.forEach(group -> {
            before.add(group.getKey());
            this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)group, AuthContextUtils.getDomain()));
        });
        return before;
    }
}

