/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.types;

import java.time.Instant;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;

public class InstantType
implements VariableType {
    public static final String TYPE_NAME = "instant";

    public String getTypeName() {
        return TYPE_NAME;
    }

    public boolean isCachable() {
        return true;
    }

    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return Instant.class.isAssignableFrom(value.getClass());
    }

    public Object getValue(ValueFields valueFields) {
        Long longValue = valueFields.getLongValue();
        if (longValue != null) {
            return Instant.ofEpochMilli(longValue);
        }
        return null;
    }

    public void setValue(Object value, ValueFields valueFields) {
        if (value != null) {
            Instant instant = (Instant)value;
            valueFields.setLongValue(Long.valueOf(instant.toEpochMilli()));
        } else {
            valueFields.setLongValue(null);
        }
    }
}

