/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.ssl;

import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthContributorAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.ssl.SslHealthIndicatorProperties;
import org.springframework.boot.actuate.ssl.SslHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.info.SslInfo;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={HealthContributorAutoConfiguration.class})
@ConditionalOnEnabledHealthIndicator(value="ssl")
@EnableConfigurationProperties(value={SslHealthIndicatorProperties.class})
public class SslHealthContributorAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"sslHealthIndicator"})
    SslHealthIndicator sslHealthIndicator(SslInfo sslInfo) {
        return new SslHealthIndicator(sslInfo);
    }

    @Bean
    @ConditionalOnMissingBean
    SslInfo sslInfo(SslBundles sslBundles, SslHealthIndicatorProperties sslHealthIndicatorProperties) {
        return new SslInfo(sslBundles, sslHealthIndicatorProperties.getCertificateValidityWarningThreshold());
    }
}

