/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.quartz;

import org.quartz.Scheduler;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure;
import org.springframework.boot.actuate.autoconfigure.quartz.QuartzEndpointProperties;
import org.springframework.boot.actuate.endpoint.SanitizingFunction;
import org.springframework.boot.actuate.quartz.QuartzEndpoint;
import org.springframework.boot.actuate.quartz.QuartzEndpointWebExtension;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.quartz.QuartzAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={QuartzAutoConfiguration.class})
@ConditionalOnClass(value={Scheduler.class})
@ConditionalOnAvailableEndpoint(value=QuartzEndpoint.class)
@EnableConfigurationProperties(value={QuartzEndpointProperties.class})
public class QuartzEndpointAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={Scheduler.class})
    @ConditionalOnMissingBean
    public QuartzEndpoint quartzEndpoint(Scheduler scheduler, ObjectProvider<SanitizingFunction> sanitizingFunctions) {
        return new QuartzEndpoint(scheduler, sanitizingFunctions.orderedStream().toList());
    }

    @Bean
    @ConditionalOnBean(value={QuartzEndpoint.class})
    @ConditionalOnMissingBean
    @ConditionalOnAvailableEndpoint(exposure={EndpointExposure.WEB})
    public QuartzEndpointWebExtension quartzEndpointWebExtension(QuartzEndpoint endpoint, QuartzEndpointProperties properties) {
        return new QuartzEndpointWebExtension(endpoint, properties.getShowValues(), properties.getRoles());
    }
}

