/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web.support;

import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.web.security.HttpCorsRequestProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;

public class RegisteredServiceCorsConfigurationSource
implements CorsConfigurationSource {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceCorsConfigurationSource.class);
    private final CasConfigurationProperties casProperties;
    private final ServicesManager servicesManager;
    private final ArgumentExtractor argumentExtractor;

    public CorsConfiguration getCorsConfiguration(@Nonnull HttpServletRequest request) {
        HttpCorsRequestProperties cors = this.casProperties.getHttpWebRequest().getCors();
        CorsConfiguration config = new CorsConfiguration();
        WebApplicationService service = this.argumentExtractor.extractService(request);
        LOGGER.trace("Extracted service [{}] from the request", (Object)service);
        RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
        config.setAllowCredentials(Boolean.valueOf(cors.isAllowCredentials()));
        config.setMaxAge(Long.valueOf(cors.getMaxAge()));
        config.setAllowedOrigins(cors.getAllowOrigins());
        config.setAllowedOriginPatterns(cors.getAllowOriginPatterns());
        config.setAllowedMethods(cors.getAllowMethods());
        config.setAllowedHeaders(cors.getAllowHeaders());
        config.setExposedHeaders(cors.getExposedHeaders());
        if (registeredService != null) {
            Set result;
            Set result2;
            Set result3;
            Set result4;
            Set result5;
            LOGGER.trace("Evaluating registered service [{}] for cors configuration", (Object)registeredService);
            if (RegisteredServiceProperty.RegisteredServiceProperties.CORS_ALLOW_CREDENTIALS.isAssignedTo(registeredService)) {
                boolean result6 = RegisteredServiceProperty.RegisteredServiceProperties.CORS_ALLOW_CREDENTIALS.getPropertyBooleanValue(registeredService);
                config.setAllowCredentials(Boolean.valueOf(result6));
            }
            if (RegisteredServiceProperty.RegisteredServiceProperties.CORS_MAX_AGE.isAssignedTo(registeredService)) {
                long result7 = RegisteredServiceProperty.RegisteredServiceProperties.CORS_MAX_AGE.getPropertyLongValue(registeredService);
                config.setMaxAge(Long.valueOf(result7));
            }
            if (RegisteredServiceProperty.RegisteredServiceProperties.CORS_ALLOWED_ORIGINS.isAssignedTo(registeredService) && (result5 = (Set)RegisteredServiceProperty.RegisteredServiceProperties.CORS_ALLOWED_ORIGINS.getPropertyValues(registeredService, Set.class)) != null) {
                config.setAllowedOrigins(new ArrayList(result5));
            }
            if (RegisteredServiceProperty.RegisteredServiceProperties.CORS_ALLOWED_ORIGIN_PATTERNS.isAssignedTo(registeredService) && (result4 = (Set)RegisteredServiceProperty.RegisteredServiceProperties.CORS_ALLOWED_ORIGIN_PATTERNS.getPropertyValues(registeredService, Set.class)) != null) {
                config.setAllowedOriginPatterns(new ArrayList(result4));
            }
            if (RegisteredServiceProperty.RegisteredServiceProperties.CORS_ALLOWED_METHODS.isAssignedTo(registeredService) && (result3 = (Set)RegisteredServiceProperty.RegisteredServiceProperties.CORS_ALLOWED_METHODS.getPropertyValues(registeredService, Set.class)) != null) {
                config.setAllowedMethods(new ArrayList(result3));
            }
            if (RegisteredServiceProperty.RegisteredServiceProperties.CORS_ALLOWED_HEADERS.isAssignedTo(registeredService) && (result2 = (Set)RegisteredServiceProperty.RegisteredServiceProperties.CORS_ALLOWED_HEADERS.getPropertyValues(registeredService, Set.class)) != null) {
                config.setAllowedHeaders(new ArrayList(result2));
            }
            if (RegisteredServiceProperty.RegisteredServiceProperties.CORS_EXPOSED_HEADERS.isAssignedTo(registeredService) && (result = (Set)RegisteredServiceProperty.RegisteredServiceProperties.CORS_EXPOSED_HEADERS.getPropertyValues(registeredService, Set.class)) != null) {
                config.setExposedHeaders(new ArrayList(result));
            }
        }
        return config;
    }

    @Generated
    public RegisteredServiceCorsConfigurationSource(CasConfigurationProperties casProperties, ServicesManager servicesManager, ArgumentExtractor argumentExtractor) {
        this.casProperties = casProperties;
        this.servicesManager = servicesManager;
        this.argumentExtractor = argumentExtractor;
    }
}

