/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityBypassEvaluator;
import org.apereo.cas.authentication.bypass.AuthenticationMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.ChainingMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.CredentialMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.DefaultChainingMultifactorAuthenticationBypassProvider;
import org.apereo.cas.authentication.bypass.GroovyMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.HttpRequestMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.PrincipalMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RegisteredServiceMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RestMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.mfa.BaseMultifactorAuthenticationProviderProperties;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.MultifactorAuthentication}, module="duo")
@Configuration(value="DuoSecurityMultifactorProviderBypassConfiguration", proxyBeanMethods=false)
class DuoSecurityMultifactorProviderBypassConfiguration {
    DuoSecurityMultifactorProviderBypassConfiguration() {
    }

    @ConditionalOnMissingBean(name={"duoSecurityBypassEvaluator"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public ChainingMultifactorAuthenticationProviderBypassEvaluator duoSecurityBypassEvaluator(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
        List duoProps = casProperties.getAuthn().getMfa().getDuo();
        List<String> duoProviderIds = duoProps.stream().map(BaseMultifactorAuthenticationProviderProperties::getId).toList();
        DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider(applicationContext);
        Collection currentBypassEvaluators = applicationContext.getBeansWithAnnotation(DuoSecurityBypassEvaluator.class).values();
        currentBypassEvaluators.stream().filter(BeanSupplier::isNotProxy).map(MultifactorAuthenticationProviderBypassEvaluator.class::cast).filter(evaluator -> !evaluator.isEmpty()).filter(evaluator -> duoProviderIds.stream().anyMatch(id -> evaluator.belongsToMultifactorAuthenticationProvider(id).isPresent())).sorted((Comparator<MultifactorAuthenticationProviderBypassEvaluator>)AnnotationAwareOrderComparator.INSTANCE).forEach(arg_0 -> ((DefaultChainingMultifactorAuthenticationBypassProvider)bypass).addMultifactorAuthenticationProviderBypassEvaluator(arg_0));
        return bypass;
    }

    @ConditionalOnMissingBean(name={"duoSecurityRestMultifactorAuthenticationProviderBypass"})
    @Bean
    @DuoSecurityBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator duoSecurityRestMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            List duoProps = casProperties.getAuthn().getMfa().getDuo();
            DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider(applicationContext);
            duoProps.stream().filter(duo -> StringUtils.isNotBlank((CharSequence)duo.getBypass().getRest().getUrl())).forEach(duo -> bypass.addMultifactorAuthenticationProviderBypassEvaluator((MultifactorAuthenticationProviderBypassEvaluator)new RestMultifactorAuthenticationProviderBypassEvaluator(duo.getBypass(), duo.getId(), applicationContext)));
            return bypass;
        }).otherwiseProxy().get();
    }

    @ConditionalOnMissingBean(name={"duoSecurityGroovyMultifactorAuthenticationProviderBypass"})
    @Bean
    @DuoSecurityBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator duoSecurityGroovyMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            List duoProps = casProperties.getAuthn().getMfa().getDuo();
            DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider(applicationContext);
            duoProps.stream().filter(duo -> duo.getBypass().getGroovy().getLocation() != null).forEach(duo -> {
                GroovyMultifactorAuthenticationProviderBypassEvaluator bypassInstance = new GroovyMultifactorAuthenticationProviderBypassEvaluator(duo.getBypass(), duo.getId(), applicationContext);
                bypass.addMultifactorAuthenticationProviderBypassEvaluator((MultifactorAuthenticationProviderBypassEvaluator)bypassInstance);
            });
            return bypass;
        }).otherwiseProxy().get();
    }

    @ConditionalOnMissingBean(name={"duoSecurityHttpRequestMultifactorAuthenticationProviderBypass"})
    @Bean
    @DuoSecurityBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator duoSecurityHttpRequestMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            List duoProps = casProperties.getAuthn().getMfa().getDuo();
            DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider(applicationContext);
            duoProps.stream().filter(duo -> {
                MultifactorAuthenticationProviderBypassProperties props = duo.getBypass();
                return StringUtils.isNotBlank((CharSequence)props.getHttpRequestHeaders()) || StringUtils.isNotBlank((CharSequence)props.getHttpRequestRemoteAddress());
            }).forEach(duo -> bypass.addMultifactorAuthenticationProviderBypassEvaluator((MultifactorAuthenticationProviderBypassEvaluator)new HttpRequestMultifactorAuthenticationProviderBypassEvaluator(duo.getBypass(), duo.getId(), (ApplicationContext)applicationContext)));
            return bypass;
        }).otherwiseProxy().get();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @DuoSecurityBypassEvaluator
    @ConditionalOnMissingBean(name={"duoSecurityCredentialMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator duoSecurityCredentialMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            List duoProps = casProperties.getAuthn().getMfa().getDuo();
            DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider(applicationContext);
            duoProps.stream().filter(duo -> StringUtils.isNotBlank((CharSequence)duo.getBypass().getCredentialClassType())).forEach(duo -> bypass.addMultifactorAuthenticationProviderBypassEvaluator((MultifactorAuthenticationProviderBypassEvaluator)new CredentialMultifactorAuthenticationProviderBypassEvaluator(duo.getBypass(), duo.getId(), applicationContext)));
            return bypass;
        }).otherwiseProxy().get();
    }

    @ConditionalOnMissingBean(name={"duoSecurityRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator"})
    @Bean
    @DuoSecurityBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator duoSecurityRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            List duoProps = casProperties.getAuthn().getMfa().getDuo();
            DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider(applicationContext);
            duoProps.forEach(duo -> bypass.addMultifactorAuthenticationProviderBypassEvaluator((MultifactorAuthenticationProviderBypassEvaluator)new RegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator(duo.getId(), applicationContext)));
            return bypass;
        }).otherwiseProxy().get();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @DuoSecurityBypassEvaluator
    @ConditionalOnMissingBean(name={"duoSecurityRegisteredServiceMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator duoSecurityRegisteredServiceMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            List duoProps = casProperties.getAuthn().getMfa().getDuo();
            DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider(applicationContext);
            duoProps.forEach(duo -> bypass.addMultifactorAuthenticationProviderBypassEvaluator((MultifactorAuthenticationProviderBypassEvaluator)new RegisteredServiceMultifactorAuthenticationProviderBypassEvaluator(duo.getId(), applicationContext)));
            return bypass;
        }).otherwiseProxy().get();
    }

    @Bean
    @ConditionalOnMissingBean(name={"duoSecurityPrincipalMultifactorAuthenticationProviderBypass"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @DuoSecurityBypassEvaluator
    public MultifactorAuthenticationProviderBypassEvaluator duoSecurityPrincipalMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            List duoProps = casProperties.getAuthn().getMfa().getDuo();
            DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider(applicationContext);
            duoProps.stream().filter(duo -> StringUtils.isNotBlank((CharSequence)duo.getBypass().getPrincipalAttributeName())).forEach(duo -> bypass.addMultifactorAuthenticationProviderBypassEvaluator((MultifactorAuthenticationProviderBypassEvaluator)new PrincipalMultifactorAuthenticationProviderBypassEvaluator(duo.getBypass(), duo.getId(), (ApplicationContext)applicationContext)));
            return bypass;
        }).otherwiseProxy().get();
    }

    @Bean
    @DuoSecurityBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"duoSecurityAuthenticationMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator duoSecurityAuthenticationMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            List duoProps = casProperties.getAuthn().getMfa().getDuo();
            DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider(applicationContext);
            duoProps.stream().filter(duo -> {
                MultifactorAuthenticationProviderBypassProperties props = duo.getBypass();
                return StringUtils.isNotBlank((CharSequence)props.getAuthenticationAttributeName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationHandlerName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationMethodName());
            }).forEach(duo -> bypass.addMultifactorAuthenticationProviderBypassEvaluator((MultifactorAuthenticationProviderBypassEvaluator)new AuthenticationMultifactorAuthenticationProviderBypassEvaluator(duo.getBypass(), duo.getId(), applicationContext)));
            return bypass;
        }).otherwiseProxy().get();
    }
}

