/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.file;

import jakarta.servlet.ServletContext;
import java.net.URL;
import org.apache.wicket.core.util.resource.UrlResourceStream;
import org.apache.wicket.util.file.IResourceFinder;
import org.apache.wicket.util.resource.IResourceStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebApplicationPath
implements IResourceFinder {
    private static final Logger log = LoggerFactory.getLogger(WebApplicationPath.class);
    private static final String WEB_INF = "WEB-INF/";
    private final ServletContext servletContext;
    private final String path;

    public WebApplicationPath(ServletContext servletContext, String path) {
        this.servletContext = servletContext;
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        this.path = path;
    }

    public IResourceStream find(Class<?> clazz, String pathname) {
        UrlResourceStream resourceStream = null;
        if (!pathname.startsWith(WEB_INF)) {
            try {
                URL url = this.servletContext.getResource(this.path + pathname);
                if (url != null) {
                    resourceStream = new UrlResourceStream(url);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return resourceStream;
    }

    public String toString() {
        return "[webapppath: " + this.path + "]";
    }
}

