/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.config;

import java.util.List;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditTrailExecutionPlan;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.PrincipalElectionStrategy;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.logout.LogoutExecutionPlan;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.logout.slo.SingleLogoutRequestExecutor;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.ServiceTicketGeneratorAuthority;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.FlowExecutionExceptionResolver;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.GatewayServicesManagementCheckAction;
import org.apereo.cas.web.flow.GenerateServiceTicketAction;
import org.apereo.cas.web.flow.PopulateSpringSecurityContextAction;
import org.apereo.cas.web.flow.ServiceAuthorizationCheckAction;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.account.PrepareAccountProfileViewAction;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.apereo.cas.web.flow.actions.FetchTicketGrantingTicketAction;
import org.apereo.cas.web.flow.actions.InitialAuthenticationAction;
import org.apereo.cas.web.flow.actions.WebflowActionBeanSupplier;
import org.apereo.cas.web.flow.login.CreateTicketGrantingTicketAction;
import org.apereo.cas.web.flow.login.GenericSuccessViewAction;
import org.apereo.cas.web.flow.login.InitialAuthenticationRequestValidationAction;
import org.apereo.cas.web.flow.login.InitialFlowSetupAction;
import org.apereo.cas.web.flow.login.InitializeLoginAction;
import org.apereo.cas.web.flow.login.RedirectUnauthorizedServiceUrlAction;
import org.apereo.cas.web.flow.login.RenderLoginAction;
import org.apereo.cas.web.flow.login.SendTicketGrantingTicketAction;
import org.apereo.cas.web.flow.login.ServiceWarningAction;
import org.apereo.cas.web.flow.login.SetServiceUnauthorizedRedirectUrlAction;
import org.apereo.cas.web.flow.login.TicketGrantingTicketCheckAction;
import org.apereo.cas.web.flow.login.VerifyRequiredServiceAction;
import org.apereo.cas.web.flow.logout.ConfirmLogoutAction;
import org.apereo.cas.web.flow.logout.FinishLogoutAction;
import org.apereo.cas.web.flow.logout.FrontChannelLogoutAction;
import org.apereo.cas.web.flow.logout.LogoutAction;
import org.apereo.cas.web.flow.logout.LogoutViewSetupAction;
import org.apereo.cas.web.flow.logout.TerminateSessionAction;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement(proxyTargetClass=false)
@AutoConfiguration
public class CasSupportActionsConfiguration {

    @Configuration(value="CasSupportActionsAccountProfileConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.AccountManagement, enabledByDefault=false)
    public static class CasSupportActionsAccountProfileConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"prepareAccountProfileViewAction"})
        public Action prepareAccountProfileViewAction(@Qualifier(value="geoLocationService") ObjectProvider<GeoLocationService> geoLocationService, ConfigurableApplicationContext applicationContext, @Qualifier(value="auditTrailExecutionPlan") AuditTrailExecutionPlan auditTrailExecutionPlan, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new PrepareAccountProfileViewAction(ticketRegistry, servicesManager, casProperties, auditTrailExecutionPlan, (GeoLocationService)geoLocationService.getIfAvailable())).withId("prepareAccountProfileViewAction").build().get();
        }
    }

    @Configuration(value="CasSupportActionsExecutionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasSupportActionsExecutionConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"fetchTicketGrantingTicketAction"})
        public Action fetchTicketGrantingTicketAction(CasConfigurationProperties casProperties, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, ConfigurableApplicationContext applicationContext, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new FetchTicketGrantingTicketAction(ticketRegistry, ticketGrantingTicketCookieGenerator)).withId("fetchTicketGrantingTicketAction").build().get();
        }

        @ConditionalOnMissingBean(name={"authenticationViaFormAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action authenticationViaFormAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="serviceTicketRequestWebflowEventResolver") CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver") CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, @Qualifier(value="adaptiveAuthenticationPolicy") AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new InitialAuthenticationAction(initialAuthenticationAttemptWebflowEventResolver, serviceTicketRequestWebflowEventResolver, adaptiveAuthenticationPolicy)).withId("authenticationViaFormAction").build().get();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"serviceAuthorizationCheck"})
        @Bean
        public Action serviceAuthorizationCheck(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new ServiceAuthorizationCheckAction(servicesManager, authenticationRequestServiceSelectionStrategies)).withId("serviceAuthorizationCheck").build().get();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"singleSignOnSessionCreated"})
        @Bean
        public Action singleSignOnSessionCreated(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> ConsumerExecutionAction.NONE).withId("singleSignOnSessionCreated").build().get();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"sendTicketGrantingTicketAction"})
        @Bean
        public Action sendTicketGrantingTicketAction(CasConfigurationProperties casProperties, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, ConfigurableApplicationContext applicationContext, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="singleSignOnParticipationStrategy") SingleSignOnParticipationStrategy webflowSingleSignOnParticipationStrategy) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new SendTicketGrantingTicketAction(ticketRegistry, ticketGrantingTicketCookieGenerator, webflowSingleSignOnParticipationStrategy)).withId("sendTicketGrantingTicketAction").build().get();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"createTicketGrantingTicketAction"})
        @Bean
        public Action createTicketGrantingTicketAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new CreateTicketGrantingTicketAction(casWebflowConfigurationContext)).withId("createTicketGrantingTicketAction").build().get();
        }

        @ConditionalOnMissingBean(name={"finishLogoutAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action finishLogoutAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="logoutExecutionPlan") LogoutExecutionPlan logoutExecutionPlan) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new FinishLogoutAction(ticketRegistry, ticketGrantingTicketCookieGenerator, argumentExtractor, servicesManager, logoutExecutionPlan, casProperties)).withId("finishLogoutAction").build().get();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"logoutAction"})
        public Action logoutAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="logoutExecutionPlan") LogoutExecutionPlan logoutExecutionPlan) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new LogoutAction(ticketRegistry, ticketGrantingTicketCookieGenerator, argumentExtractor, servicesManager, logoutExecutionPlan, casProperties)).withId("logoutAction").build().get();
        }

        @ConditionalOnMissingBean(name={"initializeLoginAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action initializeLoginAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new InitializeLoginAction(servicesManager, casProperties)).withId("initializeLoginAction").build().get();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"setServiceUnauthorizedRedirectUrlAction"})
        @Bean
        public Action setServiceUnauthorizedRedirectUrlAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new SetServiceUnauthorizedRedirectUrlAction(servicesManager)).withId("setServiceUnauthorizedRedirectUrlAction").build().get();
        }

        @ConditionalOnMissingBean(name={"renderLoginFormAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action renderLoginFormAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new RenderLoginAction(servicesManager, casProperties, (ApplicationContext)applicationContext)).withId("renderLoginFormAction").build().get();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"initialFlowSetupAction"})
        public Action initialFlowSetupAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="authenticationEventExecutionPlan") AuthenticationEventExecutionPlan authenticationEventExecutionPlan, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="warnCookieGenerator") CasCookieBuilder warnCookieGenerator, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies, @Qualifier(value="singleSignOnParticipationStrategy") SingleSignOnParticipationStrategy webflowSingleSignOnParticipationStrategy, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new InitialFlowSetupAction(CollectionUtils.wrap((Object)argumentExtractor), servicesManager, authenticationRequestServiceSelectionStrategies, ticketGrantingTicketCookieGenerator, warnCookieGenerator, casProperties, authenticationEventExecutionPlan, webflowSingleSignOnParticipationStrategy, ticketRegistrySupport)).withId("initialFlowSetupAction").build().get();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"verifyRequiredServiceAction"})
        public Action verifyRequiredServiceAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new VerifyRequiredServiceAction(servicesManager, ticketGrantingTicketCookieGenerator, casProperties, ticketRegistrySupport)).withId("verifyRequiredServiceAction").build().get();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"initialAuthenticationRequestValidationAction"})
        public Action initialAuthenticationRequestValidationAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="rankedAuthenticationProviderWebflowEventResolver") CasWebflowEventResolver rankedAuthenticationProviderWebflowEventResolver) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new InitialAuthenticationRequestValidationAction(rankedAuthenticationProviderWebflowEventResolver)).withId("initialAuthenticationRequestValidationAction").build().get();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"genericSuccessViewAction"})
        public Action genericSuccessViewAction(ConfigurableApplicationContext applicationContext, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new GenericSuccessViewAction(ticketRegistry, servicesManager, webApplicationServiceFactory, casProperties)).withId("genericSuccessViewAction").build().get();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"redirectUnauthorizedServiceUrlAction"})
        public Action redirectUnauthorizedServiceUrlAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new RedirectUnauthorizedServiceUrlAction(servicesManager, (ApplicationContext)applicationContext)).withId("redirectUnauthorizedServiceUrlAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"generateServiceTicketAction"})
        public Action generateServiceTicketAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies, @Qualifier(value="principalElectionStrategy") PrincipalElectionStrategy principalElectionStrategy, List<ServiceTicketGeneratorAuthority> serviceTicketAuthorities) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new GenerateServiceTicketAction(authenticationSystemSupport, centralAuthenticationService, ticketRegistrySupport, authenticationRequestServiceSelectionStrategies, servicesManager, principalElectionStrategy, serviceTicketAuthorities)).withId("generateServiceTicketAction").build().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"gatewayServicesManagementCheck"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action gatewayServicesManagementCheck(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new GatewayServicesManagementCheckAction(servicesManager, authenticationRequestServiceSelectionStrategies)).withId("gatewayServicesManagementCheck").build().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"frontChannelLogoutAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action frontChannelLogoutAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="logoutExecutionPlan") LogoutExecutionPlan logoutExecutionPlan) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new FrontChannelLogoutAction(ticketRegistry, ticketGrantingTicketCookieGenerator, argumentExtractor, servicesManager, logoutExecutionPlan, casProperties)).withId("frontChannelLogoutAction").build().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"ticketGrantingTicketCheckAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action ticketGrantingTicketCheckAction(@Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new TicketGrantingTicketCheckAction(ticketRegistry)).withId("ticketGrantingTicketCheckAction").build().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"terminateSessionAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action terminateSessionAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="logoutManager") LogoutManager logoutManager, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="warnCookieGenerator") CasCookieBuilder warnCookieGenerator, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="defaultSingleLogoutRequestExecutor") SingleLogoutRequestExecutor defaultSingleLogoutRequestExecutor) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new TerminateSessionAction(centralAuthenticationService, ticketGrantingTicketCookieGenerator, warnCookieGenerator, casProperties.getLogout(), logoutManager, applicationContext, defaultSingleLogoutRequestExecutor)).withId("terminateSessionAction").build().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"confirmLogoutAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action confirmLogoutAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="logoutExecutionPlan") LogoutExecutionPlan logoutExecutionPlan) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new ConfirmLogoutAction(ticketRegistry, ticketGrantingTicketCookieGenerator, argumentExtractor, servicesManager, logoutExecutionPlan, casProperties)).withId("confirmLogoutAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"logoutViewSetupAction"})
        public Action logoutViewSetupAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="ticketGrantingTicketCookieGenerator") CasCookieBuilder ticketGrantingTicketCookieGenerator, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="logoutExecutionPlan") LogoutExecutionPlan logoutExecutionPlan) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new LogoutViewSetupAction(ticketRegistry, ticketGrantingTicketCookieGenerator, argumentExtractor, servicesManager, logoutExecutionPlan, casProperties)).withId("logoutViewSetupAction").build().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"serviceWarningAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action serviceWarningAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="warnCookieGenerator") CasCookieBuilder warnCookieGenerator, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport, @Qualifier(value="principalElectionStrategy") PrincipalElectionStrategy principalElectionStrategy, List<ServiceTicketGeneratorAuthority> serviceTicketAuthorities) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new ServiceWarningAction(centralAuthenticationService, authenticationSystemSupport, ticketRegistrySupport, warnCookieGenerator, principalElectionStrategy, serviceTicketAuthorities)).withId("serviceWarningAction").build().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"populateSpringSecurityContextAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action populateSpringSecurityContextAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new PopulateSpringSecurityContextAction((ApplicationContext)applicationContext)).withId("populateSpringSecurityContextAction").build().get();
        }
    }

    @Configuration(value="CasSupportActionsExceptionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasSupportActionsExceptionConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public HandlerExceptionResolver errorHandlerResolver() {
            return new FlowExecutionExceptionResolver();
        }
    }
}

