/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.provider;

import org.springmodules.cache.provider.CacheModelValidator;
import org.springmodules.cache.provider.InvalidCacheModelException;

public abstract class AbstractCacheModelValidator
implements CacheModelValidator {
    public final void validateCachingModel(Object cachingModel) throws InvalidCacheModelException {
        Class targetClass = this.getCachingModelTargetClass();
        if (!this.isInstanceOf(cachingModel, targetClass)) {
            throw new InvalidCacheModelException("The caching model should be an instance of <" + targetClass.getName() + ">");
        }
        this.validateCachingModelProperties(cachingModel);
    }

    public final void validateFlushingModel(Object flushingModel) throws InvalidCacheModelException {
        Class targetClass = this.getFlushingModelTargetClass();
        if (!this.isInstanceOf(flushingModel, targetClass)) {
            throw new InvalidCacheModelException("The flushing model should be an instance of <" + targetClass.getName() + ">");
        }
        this.validateFlushingModelProperties(flushingModel);
    }

    protected abstract Class getCachingModelTargetClass();

    protected abstract Class getFlushingModelTargetClass();

    protected final boolean isInstanceOf(Object obj, Class targetClass) {
        return obj != null && targetClass.isAssignableFrom(obj.getClass());
    }

    protected void validateCachingModelProperties(Object cachingModel) throws InvalidCacheModelException {
    }

    protected void validateFlushingModelProperties(Object flushingModel) throws InvalidCacheModelException {
    }
}

