/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.query;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.flowable.common.engine.api.query.NativeQuery;

public abstract class BaseNativeQuery<T extends NativeQuery<?, ?>, U>
implements NativeQuery<T, U>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int maxResults = -1;
    protected int firstResult = -1;
    protected ResultType resultType;
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    protected String sqlStatement;

    public T sql(String sqlStatement) {
        this.sqlStatement = sqlStatement;
        return (T)this;
    }

    public T parameter(String name, Object value) {
        this.parameters.put(name, value);
        return (T)this;
    }

    protected Map<String, Object> generateParameterMap() {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>(this.parameters);
        parameterMap.put("sql", this.sqlStatement);
        parameterMap.put("resultType", this.resultType.toString());
        parameterMap.put("firstResult", this.firstResult);
        parameterMap.put("maxResults", this.maxResults);
        parameterMap.put("needsPaging", this.firstResult >= 0);
        String orderBy = (String)parameterMap.get("orderBy");
        if (orderBy != null && !"".equals(orderBy)) {
            String columns = "RES." + orderBy;
            parameterMap.put("orderBy", columns);
            parameterMap.put("orderByColumns", columns);
            parameterMap.put("orderByForWindow", columns);
        } else {
            parameterMap.put("orderBy", "order by RES.ID_ asc");
            parameterMap.put("orderByForWindow", "order by RES.ID_ asc");
            parameterMap.put("orderByColumns", "RES.ID_ asc");
        }
        int firstRow = this.firstResult + 1;
        parameterMap.put("firstRow", firstRow);
        int lastRow = 0;
        lastRow = this.maxResults == Integer.MAX_VALUE ? this.maxResults : this.firstResult + this.maxResults + 1;
        parameterMap.put("lastRow", lastRow);
        return parameterMap;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    protected static enum ResultType {
        LIST,
        LIST_PAGE,
        SINGLE_RESULT,
        COUNT;

    }
}

