/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.spring;

import java.net.URL;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.eventregistry.impl.EventRegistryEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class SpringEventConfigurationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringEventConfigurationHelper.class);

    public static EventRegistryEngine buildEventRegistryEngine(URL resource) {
        LOGGER.debug("==== BUILDING SPRING APPLICATION CONTEXT AND EVENT REGISTRY =========================================");
        try (GenericXmlApplicationContext applicationContext = new GenericXmlApplicationContext(new Resource[]{new UrlResource(resource)});){
            Map beansOfType = applicationContext.getBeansOfType(EventRegistryEngine.class);
            if (beansOfType == null || beansOfType.isEmpty()) {
                throw new FlowableException("no " + EventRegistryEngine.class.getName() + " defined in the application context " + resource);
            }
            EventRegistryEngine eventRegistryEngine = (EventRegistryEngine)beansOfType.values().iterator().next();
            LOGGER.debug("==== SPRING EVENT REGISTRY CREATED ==================================================================");
            EventRegistryEngine eventRegistryEngine2 = eventRegistryEngine;
            return eventRegistryEngine2;
        }
    }
}

