/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.matching.checker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.HttpConstants;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.matching.checker.MatchingChecker;
import org.pac4j.core.matching.matcher.CacheControlMatcher;
import org.pac4j.core.matching.matcher.CorsMatcher;
import org.pac4j.core.matching.matcher.HttpMethodMatcher;
import org.pac4j.core.matching.matcher.Matcher;
import org.pac4j.core.matching.matcher.StrictTransportSecurityMatcher;
import org.pac4j.core.matching.matcher.XContentTypeOptionsMatcher;
import org.pac4j.core.matching.matcher.XFrameOptionsMatcher;
import org.pac4j.core.matching.matcher.XSSProtectionMatcher;
import org.pac4j.core.matching.matcher.csrf.CsrfTokenGeneratorMatcher;
import org.pac4j.core.matching.matcher.csrf.DefaultCsrfTokenGenerator;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMatchingChecker
implements MatchingChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMatchingChecker.class);
    protected static final Matcher GET_MATCHER = new HttpMethodMatcher(HttpConstants.HTTP_METHOD.GET);
    protected static final Matcher POST_MATCHER = new HttpMethodMatcher(HttpConstants.HTTP_METHOD.POST);
    protected static final Matcher PUT_MATCHER = new HttpMethodMatcher(HttpConstants.HTTP_METHOD.PUT);
    protected static final Matcher DELETE_MATCHER = new HttpMethodMatcher(HttpConstants.HTTP_METHOD.DELETE);
    protected static final StrictTransportSecurityMatcher STRICT_TRANSPORT_MATCHER = new StrictTransportSecurityMatcher();
    protected static final XContentTypeOptionsMatcher X_CONTENT_TYPE_OPTIONS_MATCHER = new XContentTypeOptionsMatcher();
    protected static final XFrameOptionsMatcher X_FRAME_OPTIONS_MATCHER = new XFrameOptionsMatcher();
    protected static final XSSProtectionMatcher XSS_PROTECTION_MATCHER = new XSSProtectionMatcher();
    protected static final CacheControlMatcher CACHE_CONTROL_MATCHER = new CacheControlMatcher();
    protected static final CsrfTokenGeneratorMatcher CSRF_TOKEN_MATCHER = new CsrfTokenGeneratorMatcher(new DefaultCsrfTokenGenerator());
    static final List<Matcher> SECURITY_HEADERS_MATCHERS = Arrays.asList(CACHE_CONTROL_MATCHER, X_CONTENT_TYPE_OPTIONS_MATCHER, STRICT_TRANSPORT_MATCHER, X_FRAME_OPTIONS_MATCHER, XSS_PROTECTION_MATCHER);
    protected static final CorsMatcher CORS_MATCHER = new CorsMatcher();

    @Override
    public boolean matches(WebContext context, SessionStore sessionStore, String matchersValue, Map<String, Matcher> matchersMap, List<Client> clients) {
        List<Matcher> matchers = this.computeMatchers(context, sessionStore, matchersValue, matchersMap, clients);
        return this.matches(context, sessionStore, matchers);
    }

    protected List<Matcher> computeMatchers(WebContext context, SessionStore sessionStore, String matchersValue, Map<String, Matcher> matchersMap, List<Client> clients) {
        List<Matcher> matchers;
        if (CommonHelper.isBlank(matchersValue)) {
            matchers = this.computeDefaultMatchers(context, sessionStore, clients);
        } else if (matchersValue.trim().startsWith("+")) {
            String matcherNames = CommonHelper.substringAfter(matchersValue, "+");
            matchers = this.computeDefaultMatchers(context, sessionStore, clients);
            matchers.addAll(this.computeMatchersFromNames(matcherNames, matchersMap));
        } else {
            matchers = this.computeMatchersFromNames(matchersValue, matchersMap);
        }
        return matchers;
    }

    protected List<Matcher> computeDefaultMatchers(WebContext context, SessionStore sessionStore, List<Client> clients) {
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        matchers.addAll(SECURITY_HEADERS_MATCHERS);
        if (sessionStore.getSessionId(context, false).isPresent()) {
            matchers.add(CSRF_TOKEN_MATCHER);
            return matchers;
        }
        for (Client client : clients) {
            if (!(client instanceof IndirectClient)) continue;
            matchers.add(CSRF_TOKEN_MATCHER);
            return matchers;
        }
        return matchers;
    }

    protected List<Matcher> computeMatchersFromNames(String matchersValue, Map<String, Matcher> matchersMap) {
        CommonHelper.assertNotNull("matchersMap", matchersMap);
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        String[] names = matchersValue.split(",");
        int nb = names.length;
        for (int i = 0; i < nb; ++i) {
            String name = names[i].trim();
            if ("none".equalsIgnoreCase(name)) continue;
            List<Matcher> results = this.retrieveMatchers(name, matchersMap);
            CommonHelper.assertTrue(results != null && results.size() > 0, "The matcher '" + name + "' must be defined in the security configuration");
            matchers.addAll(results);
        }
        return matchers;
    }

    protected List<Matcher> retrieveMatchers(String matcherName, Map<String, Matcher> matchersMap) {
        ArrayList<Matcher> results = new ArrayList<Matcher>();
        for (Map.Entry<String, Matcher> entry : matchersMap.entrySet()) {
            if (!CommonHelper.areEqualsIgnoreCaseAndTrim(entry.getKey(), matcherName)) continue;
            results.add(entry.getValue());
            break;
        }
        if (results.size() == 0) {
            if ("hsts".equalsIgnoreCase(matcherName)) {
                return Arrays.asList(STRICT_TRANSPORT_MATCHER);
            }
            if ("nosniff".equalsIgnoreCase(matcherName)) {
                return Arrays.asList(X_CONTENT_TYPE_OPTIONS_MATCHER);
            }
            if ("noframe".equalsIgnoreCase(matcherName)) {
                return Arrays.asList(X_FRAME_OPTIONS_MATCHER);
            }
            if ("xssprotection".equalsIgnoreCase(matcherName)) {
                return Arrays.asList(XSS_PROTECTION_MATCHER);
            }
            if ("nocache".equalsIgnoreCase(matcherName)) {
                return Arrays.asList(CACHE_CONTROL_MATCHER);
            }
            if ("securityheaders".equalsIgnoreCase(matcherName)) {
                return SECURITY_HEADERS_MATCHERS;
            }
            if ("csrfToken".equalsIgnoreCase(matcherName)) {
                return Arrays.asList(CSRF_TOKEN_MATCHER);
            }
            if ("allowAjaxRequests".equalsIgnoreCase(matcherName)) {
                return Arrays.asList(CORS_MATCHER);
            }
            if ("get".equalsIgnoreCase(matcherName)) {
                return Arrays.asList(GET_MATCHER);
            }
            if ("post".equalsIgnoreCase(matcherName)) {
                return Arrays.asList(POST_MATCHER);
            }
            if ("put".equalsIgnoreCase(matcherName)) {
                return Arrays.asList(PUT_MATCHER);
            }
            if ("delete".equalsIgnoreCase(matcherName)) {
                return Arrays.asList(DELETE_MATCHER);
            }
        }
        return results;
    }

    protected boolean matches(WebContext context, SessionStore sessionStore, List<Matcher> matchers) {
        if (!matchers.isEmpty()) {
            for (Matcher matcher : matchers) {
                boolean matches = matcher.matches(context, sessionStore);
                LOGGER.debug("Checking matcher: {} -> {}", (Object)matcher, (Object)matches);
                if (matches) continue;
                return false;
            }
        }
        return true;
    }

    static {
        CORS_MATCHER.setAllowOrigin("*");
        CORS_MATCHER.setAllowCredentials(true);
        HashSet<HttpConstants.HTTP_METHOD> methods = new HashSet<HttpConstants.HTTP_METHOD>();
        methods.add(HttpConstants.HTTP_METHOD.GET);
        methods.add(HttpConstants.HTTP_METHOD.PUT);
        methods.add(HttpConstants.HTTP_METHOD.POST);
        methods.add(HttpConstants.HTTP_METHOD.DELETE);
        methods.add(HttpConstants.HTTP_METHOD.OPTIONS);
        CORS_MATCHER.setAllowMethods(methods);
    }
}

