/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import org.apache.sling.auth.oauth_client.impl.Converter;
import org.apache.sling.auth.oauth_client.spi.OidcAuthCredentials;
import org.apache.sling.auth.oauth_client.spi.UserInfoProcessor;
import org.apache.sling.commons.crypto.CryptoService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={UserInfoProcessor.class}, property={"service.ranking:Integer=10"})
@Designate(ocd=Config.class, factory=true)
public class SlingUserInfoProcessorImpl
implements UserInfoProcessor {
    private static final Logger logger = LoggerFactory.getLogger(SlingUserInfoProcessorImpl.class);
    private final CryptoService cryptoService;
    private final boolean storeAccessToken;
    private final boolean storeRefreshToken;
    private final boolean groupsInIdToken;
    private final String groupsClaimName;
    private final String connection;

    @Activate
    public SlingUserInfoProcessorImpl(@Reference(policyOption=ReferencePolicyOption.GREEDY) CryptoService service, Config config) {
        this.cryptoService = service;
        this.storeAccessToken = config.storeAccessToken();
        this.storeRefreshToken = config.storeRefreshToken();
        this.groupsInIdToken = config.groupsInIdToken();
        this.groupsClaimName = config.groupsClaimName();
        if (config.connection() == null || config.connection().isEmpty()) {
            throw new IllegalArgumentException("Connection name must not be null or empty");
        }
        this.connection = config.connection();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public OidcAuthCredentials process(@Nullable String stringUserInfo, @NotNull String stringTokenResponse, @NotNull String oidcSubject, @NotNull String idp) {
        tokenResponse = SlingUserInfoProcessorImpl.parseTokenResponse(stringTokenResponse);
        userInfo = SlingUserInfoProcessorImpl.parseUserInfo(stringUserInfo);
        tokens = Converter.toSlingOAuthTokens(tokenResponse.toSuccessResponse().getTokens());
        credentials = new OidcAuthCredentials(oidcSubject, idp);
        credentials.setAttribute(".token", "");
        if (userInfo != null) {
            SlingUserInfoProcessorImpl.logger.debug("Preferred Username: {}", (Object)userInfo.getPreferredUsername());
            SlingUserInfoProcessorImpl.logger.debug("Subject: {}", (Object)userInfo.getSubject());
            SlingUserInfoProcessorImpl.logger.debug("Email: {}", (Object)userInfo.getEmailAddress());
            SlingUserInfoProcessorImpl.logger.debug("Name: {}", (Object)userInfo.getGivenName());
            SlingUserInfoProcessorImpl.logger.debug("FamilyName: {}", (Object)userInfo.getFamilyName());
            userInfo.toJSONObject().forEach((BiConsumer<String, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$process$0(org.apache.sling.auth.oauth_client.spi.OidcAuthCredentials java.lang.String java.lang.Object ), (Ljava/lang/String;Ljava/lang/Object;)V)((OidcAuthCredentials)credentials));
        }
        if (this.groupsInIdToken) {
            try {
                groups = tokenResponse.toSuccessResponse().getTokens().toOIDCTokens().getIDToken().getJWTClaimsSet().getClaim(this.groupsClaimName);
                if (!(groups instanceof List)) ** GOTO lbl26
                SlingUserInfoProcessorImpl.logger.debug("Groups from ID Token: {}", groups);
                ((List)groups).forEach((Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$process$1(org.apache.sling.auth.oauth_client.spi.OidcAuthCredentials java.lang.Object ), (Ljava/lang/Object;)V)((OidcAuthCredentials)credentials));
            }
            catch (java.text.ParseException e) {
                throw new RuntimeException(e);
            }
        } else if (userInfo != null && (groups = userInfo.toJSONObject().remove((Object)this.groupsClaimName)) instanceof JSONArray) {
            groupJsonArray = (JSONArray)groups;
            SlingUserInfoProcessorImpl.logger.debug("Groups: {}", groups);
            groupJsonArray.forEach((Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$process$2(org.apache.sling.auth.oauth_client.spi.OidcAuthCredentials java.lang.Object ), (Ljava/lang/Object;)V)((OidcAuthCredentials)credentials));
        }
lbl26:
        // 5 sources

        accessToken = tokens.accessToken();
        if (this.storeAccessToken && accessToken != null) {
            credentials.setAttribute("access_token", this.cryptoService.encrypt(accessToken));
        } else {
            SlingUserInfoProcessorImpl.logger.debug("Access Token is null, omit adding as credentials attribute '{}'", (Object)"access_token");
        }
        refreshToken = tokens.refreshToken();
        if (this.storeRefreshToken && refreshToken != null) {
            credentials.setAttribute("refresh_token", this.cryptoService.encrypt(refreshToken));
        } else {
            SlingUserInfoProcessorImpl.logger.debug("Refresh Token is null, omit adding as credentials attribute '{}'", (Object)"refresh_token");
        }
        return credentials;
    }

    @Nullable
    private static UserInfo parseUserInfo(@Nullable String stringUserInfo) {
        if (stringUserInfo != null) {
            try {
                return UserInfo.parse((String)stringUserInfo);
            }
            catch (ParseException e) {
                throw new RuntimeException("Failed to parse UserInfo in UserInfoProcessor", e);
            }
        }
        return null;
    }

    @NotNull
    private static TokenResponse parseTokenResponse(@NotNull String stringTokenResponse) {
        try {
            JSONObject jsonTokenResponse = (JSONObject)JSONValue.parse((String)stringTokenResponse);
            return OIDCTokenResponse.parse((JSONObject)jsonTokenResponse);
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to parse TokenResponse in UserInfoProcessor", e);
        }
    }

    @Override
    @NotNull
    public String connection() {
        return this.connection;
    }

    private static /* synthetic */ void lambda$process$2(OidcAuthCredentials credentials, Object group) {
        credentials.addGroup(group.toString());
    }

    private static /* synthetic */ void lambda$process$1(OidcAuthCredentials credentials, Object group) {
        credentials.addGroup(group.toString());
    }

    private static /* synthetic */ void lambda$process$0(OidcAuthCredentials credentials, String key, Object value) {
        if (value != null) {
            credentials.setAttribute("profile/" + key, value.toString());
        }
    }

    @ObjectClassDefinition(name="Apache Sling Oidc UserInfo Processor", description="Apache Sling Oidc UserInfo Processor Service")
    static @interface Config {
        @AttributeDefinition(name="groupsInIdToken", description="Read groups from ID Token")
        public boolean groupsInIdToken() default false;

        @AttributeDefinition(name="storeAccessToken", description="Store access Token under User Node")
        public boolean storeAccessToken() default false;

        @AttributeDefinition(name="storeRefreshToken", description="Store access Refresh under User Node")
        public boolean storeRefreshToken() default false;

        @AttributeDefinition(name="groupsClaimName", description="Name of the claim in the ID Token or UserInfo that contains the groups. If not set, the default 'groups' is used")
        public String groupsClaimName() default "groups";

        @AttributeDefinition(name="connection", description="OIDC Connection Name")
        public String connection();
    }
}

