/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.ManageableMessage;
import org.apache.qpid.server.model.NotFoundException;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.auth.SocketConnectionMetaData;
import org.apache.qpid.server.util.FixedKeyMapCreator;
import org.apache.qpid.server.virtualhost.ProvidedStoreVirtualHostImpl;

final class ProvidedStoreVirtualHostImplWithAccessChecking
extends ProvidedStoreVirtualHostImpl {
    private static final FixedKeyMapCreator GET_CONNECTION_MAP_CREATOR = new FixedKeyMapCreator("name");
    private static final FixedKeyMapCreator PUBLISH_MESSAGE_MAP_CREATOR = new FixedKeyMapCreator("message");
    private static final FixedKeyMapCreator EXTRACT_CONFIG_MAP_CREATOR = new FixedKeyMapCreator("includeSecureAttributes");
    private static final FixedKeyMapCreator IMPORT_MESSAGE_STORE_MAP_CREATOR = new FixedKeyMapCreator("source");
    private static final FixedKeyMapCreator PURGE_LINK_REGISTRY_MAP_CREATOR = new FixedKeyMapCreator("containerIdPattern", "role", "linkNamePattern");
    private static final FixedKeyMapCreator CLEAR_MATCHING_QUEUES_MAP_CREATOR = new FixedKeyMapCreator("queueNamePattern");
    private static final FixedKeyMapCreator CLEAR_QUEUES_MAP_CREATOR = new FixedKeyMapCreator("queues");

    ProvidedStoreVirtualHostImplWithAccessChecking(Map<String, Object> attributes, VirtualHostNode<?> virtualhostnode) {
        super(attributes, virtualhostnode);
    }

    @Override
    public Map<String, Object> getStatistics(List<String> statistics) {
        return super.getStatistics(statistics);
    }

    @Override
    public String setContextVariable(final String name, final String value) {
        return this.doSync(this.doOnConfigThread(new Task<CompletableFuture<String>, RuntimeException>(){
            private String _args;

            @Override
            public CompletableFuture<String> execute() {
                return CompletableFuture.completedFuture(ProvidedStoreVirtualHostImplWithAccessChecking.super.setContextVariable(name, value));
            }

            @Override
            public String getObject() {
                return ProvidedStoreVirtualHostImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "setContextVariable";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "name=" + name + ",value=" + value;
                }
                return this._args;
            }
        }));
    }

    @Override
    public String removeContextVariable(final String name) {
        return this.doSync(this.doOnConfigThread(new Task<CompletableFuture<String>, RuntimeException>(){
            private String _args;

            @Override
            public CompletableFuture<String> execute() {
                return CompletableFuture.completedFuture(ProvidedStoreVirtualHostImplWithAccessChecking.super.removeContextVariable(name));
            }

            @Override
            public String getObject() {
                return ProvidedStoreVirtualHostImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "removeContextVariable";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "name=" + name;
                }
                return this._args;
            }
        }));
    }

    @Override
    public Collection<? extends Connection<?>> getConnections() {
        return super.getConnections();
    }

    @Override
    public void resetStatistics() {
        this.authorise(Operation.INVOKE_METHOD("resetStatistics"));
        this.doSync(this.doOnConfigThread(new Task<CompletableFuture<Void>, RuntimeException>(){
            private String _args;

            @Override
            public CompletableFuture<Void> execute() {
                ProvidedStoreVirtualHostImplWithAccessChecking.super.resetStatistics();
                return CompletableFuture.completedFuture(null);
            }

            @Override
            public String getObject() {
                return ProvidedStoreVirtualHostImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "resetStatistics";
            }

            @Override
            public String getArguments() {
                return this._args;
            }
        }));
    }

    @Override
    public Connection<?> getConnection(String name) {
        this.authorise(Operation.INVOKE_METHOD("getConnection"), GET_CONNECTION_MAP_CREATOR.createMap(name));
        return super.getConnection(name);
    }

    @Override
    public int publishMessage(ManageableMessage message) {
        this.authorise(Operation.INVOKE_METHOD("publishMessage"), PUBLISH_MESSAGE_MAP_CREATOR.createMap(message));
        return super.publishMessage(message);
    }

    @Override
    public Map<String, Object> extractConfig(boolean includeSecureAttributes) {
        this.authorise(Operation.INVOKE_METHOD("extractConfig"), EXTRACT_CONFIG_MAP_CREATOR.createMap(includeSecureAttributes));
        return super.extractConfig(includeSecureAttributes);
    }

    @Override
    public Content exportMessageStore() {
        this.authorise(Operation.INVOKE_METHOD("exportMessageStore"));
        return super.exportMessageStore();
    }

    @Override
    public void importMessageStore(String source) {
        this.authorise(Operation.INVOKE_METHOD("importMessageStore"), IMPORT_MESSAGE_STORE_MAP_CREATOR.createMap(source));
        super.importMessageStore(source);
    }

    @Override
    public SocketConnectionMetaData getConnectionMetaData() {
        return super.getConnectionMetaData();
    }

    @Override
    public Object dumpLinkRegistry() {
        this.authorise(Operation.INVOKE_METHOD("dumpLinkRegistry"));
        return super.dumpLinkRegistry();
    }

    @Override
    public void purgeLinkRegistry(String containerIdPattern, String role, String linkNamePattern) {
        this.authorise(Operation.INVOKE_METHOD("purgeLinkRegistry"), PURGE_LINK_REGISTRY_MAP_CREATOR.createMap(containerIdPattern, role, linkNamePattern));
        super.purgeLinkRegistry(containerIdPattern, role, linkNamePattern);
    }

    @Override
    public long clearMatchingQueues(String queueNamePattern) {
        this.authorise(Operation.INVOKE_METHOD("clearMatchingQueues"), CLEAR_MATCHING_QUEUES_MAP_CREATOR.createMap(queueNamePattern));
        return super.clearMatchingQueues(queueNamePattern);
    }

    @Override
    public long clearQueues(Collection<String> queues) {
        this.authorise(Operation.INVOKE_METHOD("clearQueues"), CLEAR_QUEUES_MAP_CREATOR.createMap(queues));
        return super.clearQueues(queues);
    }

    @Override
    public Queue<?> getSubscriptionQueue(final String exchangeName, final Map<String, Object> attributes, final Map<String, Map<String, Object>> bindings) {
        return (Queue)this.doSync(this.doOnConfigThread(new Task<CompletableFuture<Queue<?>>, RuntimeException>(){
            private String _args;

            @Override
            public CompletableFuture<Queue<?>> execute() {
                return CompletableFuture.completedFuture(ProvidedStoreVirtualHostImplWithAccessChecking.super.getSubscriptionQueue(exchangeName, attributes, bindings));
            }

            @Override
            public String getObject() {
                return ProvidedStoreVirtualHostImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "getSubscriptionQueue";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "exchangeName=" + exchangeName + ",attributes=" + String.valueOf(attributes) + ",bindings=" + String.valueOf(bindings);
                }
                return this._args;
            }
        }));
    }

    @Override
    public void removeSubscriptionQueue(final String queueName) throws NotFoundException {
        this.doSync(this.doOnConfigThread(new Task<CompletableFuture<Void>, RuntimeException>(){
            private String _args;

            @Override
            public CompletableFuture<Void> execute() {
                try {
                    ProvidedStoreVirtualHostImplWithAccessChecking.super.removeSubscriptionQueue(queueName);
                    return CompletableFuture.completedFuture(null);
                }
                catch (NotFoundException e) {
                    return CompletableFuture.failedFuture(e);
                }
            }

            @Override
            public String getObject() {
                return ProvidedStoreVirtualHostImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "removeSubscriptionQueue";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "queueName=" + queueName;
                }
                return this._args;
            }
        }));
    }
}

