/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.filter;

import java.util.Objects;
import org.apache.sshd.common.filter.Filter;
import org.apache.sshd.common.filter.FilterChain;
import org.apache.sshd.common.filter.FilterContext;

public class DefaultFilterChain
implements FilterChain {
    private FilterContext head;
    private FilterContext tail;

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public synchronized FilterContext addFirst(Filter filter) {
        FilterContext ctx = new FilterContext(filter);
        filter.adding(ctx);
        ctx.prev = null;
        ctx.next = this.head;
        if (this.head != null) {
            ctx.next.prev = ctx;
        }
        this.head = ctx;
        if (this.tail == null) {
            this.tail = ctx;
        }
        filter.added(ctx);
        return ctx;
    }

    @Override
    public synchronized FilterContext addLast(Filter filter) {
        FilterContext ctx = new FilterContext(filter);
        filter.adding(ctx);
        ctx.next = null;
        ctx.prev = this.tail;
        if (this.tail != null) {
            ctx.prev.next = ctx;
        }
        this.tail = ctx;
        if (this.head == null) {
            this.head = ctx;
        }
        filter.added(ctx);
        return ctx;
    }

    @Override
    public synchronized FilterContext addBefore(Filter filter, FilterContext before) {
        Objects.requireNonNull(before);
        FilterContext ctx = new FilterContext(filter);
        filter.adding(ctx);
        ctx.next = before;
        ctx.prev = before.prev;
        before.prev = ctx;
        if (ctx.prev == null) {
            this.head = ctx;
        } else {
            ctx.prev.next = ctx;
        }
        filter.added(ctx);
        return ctx;
    }

    @Override
    public synchronized FilterContext addAfter(Filter filter, FilterContext after) {
        Objects.requireNonNull(after);
        FilterContext ctx = new FilterContext(filter);
        filter.adding(ctx);
        ctx.prev = after;
        ctx.next = after.next;
        after.next = ctx;
        if (ctx.next == null) {
            this.tail = ctx;
        } else {
            ctx.next.prev = ctx;
        }
        filter.added(ctx);
        return ctx;
    }

    @Override
    public synchronized Filter getFirst() {
        return this.head == null ? null : this.head.filter;
    }

    @Override
    public synchronized Filter getLast() {
        return this.tail == null ? null : this.tail.filter;
    }
}

