/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory;

import com.github.f4b6a3.uuid.enums.UuidNamespace;
import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.UuidFactory;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.UUID;

public abstract class AbstNameBasedFactory
extends UuidFactory {
    protected byte[] namespace;
    protected final String algorithm;
    protected static final String ALGORITHM_MD5 = "MD5";
    protected static final String ALGORITHM_SHA1 = "SHA-1";

    protected AbstNameBasedFactory(UuidVersion version, String algorithm, byte[] namespace) {
        super(version);
        if (!UuidVersion.VERSION_NAME_BASED_MD5.equals((Object)version) && !UuidVersion.VERSION_NAME_BASED_SHA1.equals((Object)version)) {
            throw new IllegalArgumentException("Invalid UUID version");
        }
        if (!ALGORITHM_MD5.equals(algorithm) && !ALGORITHM_SHA1.equals(algorithm)) {
            throw new IllegalArgumentException("Invalid message digest algorithm");
        }
        this.algorithm = algorithm;
        if (namespace != null) {
            if (namespace.length == 16) {
                this.namespace = namespace;
            } else {
                throw new IllegalArgumentException("Invalid namespace");
            }
        }
    }

    public UUID create(byte[] name) {
        return this.create(this.namespace, AbstNameBasedFactory.nameBytes(name));
    }

    public UUID create(String name) {
        return this.create(this.namespace, AbstNameBasedFactory.nameBytes(name));
    }

    public UUID create(UUID namespace, byte[] name) {
        return this.create(AbstNameBasedFactory.namespaceBytes(namespace), AbstNameBasedFactory.nameBytes(name));
    }

    public UUID create(UUID namespace, String name) {
        return this.create(AbstNameBasedFactory.namespaceBytes(namespace), AbstNameBasedFactory.nameBytes(name));
    }

    public UUID create(String namespace, byte[] name) {
        return this.create(AbstNameBasedFactory.namespaceBytes(namespace), AbstNameBasedFactory.nameBytes(name));
    }

    public UUID create(String namespace, String name) {
        return this.create(AbstNameBasedFactory.namespaceBytes(namespace), AbstNameBasedFactory.nameBytes(name));
    }

    public UUID create(UuidNamespace namespace, byte[] name) {
        return this.create(AbstNameBasedFactory.namespaceBytes(namespace), AbstNameBasedFactory.nameBytes(name));
    }

    public UUID create(UuidNamespace namespace, String name) {
        return this.create(AbstNameBasedFactory.namespaceBytes(namespace), AbstNameBasedFactory.nameBytes(name));
    }

    @Override
    public UUID create() {
        return this.create(UuidFactory.Parameters.builder().build());
    }

    @Override
    public UUID create(UuidFactory.Parameters parameters) {
        return this.create(parameters.getNamespace(), parameters.getName());
    }

    private UUID create(byte[] namespace, byte[] name) {
        MessageDigest hasher;
        Objects.requireNonNull(name, "Null name");
        try {
            hasher = MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (namespace != null) {
            hasher.update(namespace);
        }
        byte[] hash = hasher.digest(name);
        long msb = ByteUtil.toNumber(hash, 0, 8);
        long lsb = ByteUtil.toNumber(hash, 8, 16);
        return this.toUuid(msb, lsb);
    }
}

