/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.EntryRebalancingRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessage;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class EntryRebalancingResultAccessLogMessage
extends EntryRebalancingRequestAccessLogMessage {
    private static final long serialVersionUID = -5593721315305821425L;
    @Nullable
    private final Boolean sourceAltered;
    @Nullable
    private final Boolean targetAltered;
    @Nullable
    private final Integer entriesAddedToTarget;
    @Nullable
    private final Integer entriesDeletedFromSource;
    @Nullable
    private final Integer entriesReadFromSource;
    @Nullable
    private final ResultCode resultCode;
    @Nullable
    private final String adminActionRequired;
    @Nullable
    private final String errorMessage;

    public EntryRebalancingResultAccessLogMessage(@NotNull String s) throws LogException {
        this(new LogMessage(s));
    }

    public EntryRebalancingResultAccessLogMessage(@NotNull LogMessage m) {
        super(m);
        Integer rcInteger = this.getNamedValueAsInteger("resultCode");
        this.resultCode = rcInteger == null ? null : ResultCode.valueOf(rcInteger);
        this.adminActionRequired = this.getNamedValue("adminActionRequired");
        this.entriesAddedToTarget = this.getNamedValueAsInteger("entriesAddedToTarget");
        this.entriesDeletedFromSource = this.getNamedValueAsInteger("entriesDeletedFromSource");
        this.entriesReadFromSource = this.getNamedValueAsInteger("entriesReadFromSource");
        this.errorMessage = this.getNamedValue("errorMessage");
        this.sourceAltered = this.getNamedValueAsBoolean("sourceAltered");
        this.targetAltered = this.getNamedValueAsBoolean("targetAltered");
    }

    @Nullable
    public ResultCode getResultCode() {
        return this.resultCode;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Nullable
    public String getAdminActionRequired() {
        return this.adminActionRequired;
    }

    @Nullable
    public Boolean sourceAltered() {
        return this.sourceAltered;
    }

    @Nullable
    public Boolean targetAltered() {
        return this.targetAltered;
    }

    @Nullable
    public Integer getEntriesReadFromSource() {
        return this.entriesReadFromSource;
    }

    @Nullable
    public Integer getEntriesAddedToTarget() {
        return this.entriesAddedToTarget;
    }

    @Nullable
    public Integer getEntriesDeletedFromSource() {
        return this.entriesDeletedFromSource;
    }

    @Override
    @NotNull
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.ENTRY_REBALANCING_RESULT;
    }
}

