/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed;

import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefWithCell;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.typed.ActorRefResolver;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.actor.typed.internal.adapter.ActorRefAdapter;
import org.apache.pekko.actor.typed.internal.adapter.ActorRefAdapter$;
import org.apache.pekko.actor.typed.scaladsl.adapter.package$ClassicActorSystemOps$;
import org.apache.pekko.annotation.InternalApi;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005}3Qa\u0002\u0005\u0001\u0019IA\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I!\u0007\u0005\u0006W\u0001!\t\u0001\f\u0005\bg\u0001\u0011\r\u0011\"\u00035\u0011\u0019I\u0004\u0001)A\u0005k!)!\b\u0001C!w!)\u0001\u000b\u0001C!#\n!\u0012i\u0019;peJ+gMU3t_24XM]%na2T!!\u0003\u0006\u0002\u000bQL\b/\u001a3\u000b\u0005-a\u0011!B1di>\u0014(BA\u0007\u000f\u0003\u0015\u0001Xm[6p\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0016\u001b\u0005A\u0011B\u0001\f\t\u0005A\t5\r^8s%\u00164'+Z:pYZ,'/\u0001\u0004tsN$X-\\\u0002\u0001a\tQr\u0004E\u0002\u00157uI!\u0001\b\u0005\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\u001c\t\u0003=}a\u0001\u0001B\u0005!\u0003\u0005\u0005\t\u0011!B\u0001C\t\u0019q\fJ\u001a\u0012\u0005\tB\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#a\u0002(pi\"Lgn\u001a\t\u0003G%J!A\u000b\u0013\u0003\u0007\u0005s\u00170\u0001\u0004=S:LGO\u0010\u000b\u0003[9\u0002\"\u0001\u0006\u0001\t\u000b]\u0011\u0001\u0019A\u00181\u0005A\u0012\u0004c\u0001\u000b\u001ccA\u0011aD\r\u0003\nA9\n\t\u0011!A\u0003\u0002\u0005\nQb\u00197bgNL7mU=ti\u0016lW#A\u001b\u0011\u0005Y:T\"\u0001\u0006\n\u0005aR!aE#yi\u0016tG-\u001a3BGR|'oU=ti\u0016l\u0017AD2mCN\u001c\u0018nY*zgR,W\u000eI\u0001\u0016i>\u001cVM]5bY&T\u0018\r^5p]\u001a{'/\\1u+\tad\n\u0006\u0002>\u0011B\u0011a(\u0012\b\u0003\u007f\r\u0003\"\u0001\u0011\u0013\u000e\u0003\u0005S!A\u0011\r\u0002\rq\u0012xn\u001c;?\u0013\t!E%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\r\u001e\u0013aa\u0015;sS:<'B\u0001#%\u0011\u0015IU\u00011\u0001K\u0003\r\u0011XM\u001a\t\u0004)-k\u0015B\u0001'\t\u0005!\t5\r^8s%\u00164\u0007C\u0001\u0010O\t\u0015yUA1\u0001\"\u0005\u0005!\u0016a\u0004:fg>dg/Z!di>\u0014(+\u001a4\u0016\u0005I+FCA*W!\r!2\n\u0016\t\u0003=U#Qa\u0014\u0004C\u0002\u0005BQa\u0016\u0004A\u0002u\n!c]3sS\u0006d\u0017N_3e\u0003\u000e$xN\u001d*fM\"\u0012\u0001!\u0017\t\u00035vk\u0011a\u0017\u0006\u000392\t!\"\u00198o_R\fG/[8o\u0013\tq6LA\u0006J]R,'O\\1m\u0003BL\u0007")
@InternalApi
public class ActorRefResolverImpl
extends ActorRefResolver {
    private final ActorSystem<?> system;
    private final ExtendedActorSystem classicSystem;

    private ExtendedActorSystem classicSystem() {
        return this.classicSystem;
    }

    @Override
    public <T> String toSerializationFormat(org.apache.pekko.actor.typed.ActorRef<T> ref) {
        InternalActorRef internalActorRef = ActorRefAdapter$.MODULE$.toClassic(ref);
        if (internalActorRef instanceof ActorRefWithCell) {
            ExtendedActorSystem originSystem = (ExtendedActorSystem)((ActorRefWithCell)internalActorRef).underlying().system();
            if (originSystem == this.classicSystem()) {
                return this.toSerializationFormatWithAddress$1(ref);
            }
            throw new IllegalArgumentException(new StringBuilder(178).append("ActorRefResolver for ActorSystem [").append(this.classicSystem().provider().getDefaultAddress()).append("] shouldn't be used for ").append("serialization of ActorRef that originates from another ActorSystem ").append("[").append(originSystem.provider().getDefaultAddress()).append("]. Use the ActorRefResolver for that system instead.").toString());
        }
        return this.toSerializationFormatWithAddress$1(ref);
    }

    @Override
    public <T> org.apache.pekko.actor.typed.ActorRef<T> resolveActorRef(String serializedActorRef) {
        ActorRef ref = this.classicSystem().provider().resolveActorRef(serializedActorRef);
        if (ref == this.classicSystem().provider().ignoreRef()) {
            return package$ClassicActorSystemOps$.MODULE$.toTyped$extension((org.apache.pekko.actor.ActorSystem)this.classicSystem()).ignoreRef();
        }
        return new ActorRefAdapter((InternalActorRef)ref);
    }

    private final String toSerializationFormatWithAddress$1(org.apache.pekko.actor.typed.ActorRef ref$1) {
        return ref$1.path().toSerializationFormatWithAddress(this.system.address());
    }

    public ActorRefResolverImpl(ActorSystem<?> system) {
        this.system = system;
        this.classicSystem = (ExtendedActorSystem)system.classicSystem();
    }
}

