/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.james.mime4j.codec.Base64OutputStream;
import org.apache.james.mime4j.codec.QuotedPrintableOutputStream;
import org.apache.james.mime4j.dom.BinaryBody;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.MessageWriter;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.SingleBody;
import org.apache.james.mime4j.dom.field.ContentTypeField;
import org.apache.james.mime4j.dom.field.FieldName;
import org.apache.james.mime4j.message.MultipartImpl;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.util.ByteArrayBuffer;
import org.apache.james.mime4j.util.ByteSequence;
import org.apache.james.mime4j.util.ContentUtil;
import org.apache.james.mime4j.util.MimeUtil;
import org.apache.james.mime4j.util.RecycledByteArrayBuffer;

public class DefaultMessageWriter
implements MessageWriter {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] DASHES = new byte[]{45, 45};

    public static byte[] asBytes(Message message) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DefaultMessageWriter writer = new DefaultMessageWriter();
        writer.writeMessage(message, buffer);
        return buffer.toByteArray();
    }

    @Override
    public void writeBody(Body body, OutputStream out) throws IOException {
        if (body instanceof Message) {
            this.writeEntity((Message)body, out);
        } else if (body instanceof Multipart) {
            this.writeMultipart((Multipart)body, out);
        } else if (body instanceof SingleBody) {
            ((SingleBody)body).writeTo(out);
        } else {
            throw new IllegalArgumentException("Unsupported body class");
        }
    }

    @Override
    public void writeEntity(Entity entity, OutputStream out) throws IOException {
        Header header = entity.getHeader();
        if (header == null) {
            throw new IllegalArgumentException("Missing header");
        }
        this.writeHeader(header, out);
        Body body = entity.getBody();
        if (body == null) {
            throw new IllegalArgumentException("Missing body");
        }
        boolean binaryBody = body instanceof BinaryBody;
        OutputStream encOut = this.encodeStream(out, entity.getContentTransferEncoding(), binaryBody);
        this.writeBody(body, encOut);
        if (encOut != out) {
            encOut.close();
        }
    }

    @Override
    public void writeMessage(Message message, OutputStream out) throws IOException {
        this.writeEntity(message, out);
    }

    @Override
    public void writeMultipart(Multipart multipart, OutputStream out) throws IOException {
        ByteSequence epilogue;
        ByteSequence preamble;
        ContentTypeField contentType = this.getContentType(multipart);
        ByteSequence boundary = this.getBoundary(contentType);
        if (multipart instanceof MultipartImpl) {
            preamble = ((MultipartImpl)multipart).getPreambleRaw();
            epilogue = ((MultipartImpl)multipart).getEpilogueRaw();
        } else {
            preamble = multipart.getPreamble() != null ? ContentUtil.encode(multipart.getPreamble()) : null;
            ByteSequence byteSequence = epilogue = multipart.getEpilogue() != null ? ContentUtil.encode(multipart.getEpilogue()) : null;
        }
        if (preamble != null) {
            this.writeBytes(preamble, out);
            out.write(CRLF);
        }
        for (Entity bodyPart : multipart.getBodyParts()) {
            out.write(DASHES);
            this.writeBytes(boundary, out);
            out.write(CRLF);
            this.writeEntity(bodyPart, out);
            out.write(CRLF);
        }
        out.write(DASHES);
        this.writeBytes(boundary, out);
        out.write(DASHES);
        out.write(CRLF);
        if (epilogue != null) {
            this.writeBytes(epilogue, out);
        }
    }

    @Override
    public void writeField(Field field2, OutputStream out) throws IOException {
        ByteSequence raw = field2.getRaw();
        if (raw == null) {
            StringBuilder buf = new StringBuilder();
            buf.append(field2.getName());
            buf.append(": ");
            String body = field2.getBody();
            if (body != null) {
                buf.append(body);
            }
            raw = ContentUtil.encode(MimeUtil.fold(buf.toString(), 0));
        }
        this.writeBytes(raw, out);
        out.write(CRLF);
    }

    @Override
    public void writeHeader(Header header, OutputStream out) throws IOException {
        for (Field field2 : header) {
            this.writeField(field2, out);
        }
        out.write(CRLF);
    }

    protected OutputStream encodeStream(OutputStream out, String encoding, boolean binaryBody) throws IOException {
        if (MimeUtil.isBase64Encoding(encoding)) {
            return new Base64OutputStream(out);
        }
        if (MimeUtil.isQuotedPrintableEncoded(encoding)) {
            return new QuotedPrintableOutputStream(out, binaryBody);
        }
        return out;
    }

    private ContentTypeField getContentType(Multipart multipart) {
        Entity parent = multipart.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("Missing parent entity in multipart");
        }
        Header header = parent.getHeader();
        if (header == null) {
            throw new IllegalArgumentException("Missing header in parent entity");
        }
        ContentTypeField contentType = (ContentTypeField)header.getField(FieldName.CONTENT_TYPE_LOWERCASE);
        if (contentType == null) {
            throw new IllegalArgumentException("Content-Type field not specified");
        }
        return contentType;
    }

    private ByteSequence getBoundary(ContentTypeField contentType) {
        String boundary = contentType.getBoundary();
        if (boundary == null) {
            throw new IllegalArgumentException("Multipart boundary not specified. Mime-Type: " + contentType.getMimeType() + ", Raw: " + contentType.toString());
        }
        return ContentUtil.encode(boundary);
    }

    private void writeBytes(ByteSequence byteSequence, OutputStream out) throws IOException {
        if (byteSequence instanceof ByteArrayBuffer) {
            ByteArrayBuffer bab = (ByteArrayBuffer)byteSequence;
            out.write(bab.buffer(), 0, bab.length());
        } else if (byteSequence instanceof RecycledByteArrayBuffer) {
            RecycledByteArrayBuffer bab = (RecycledByteArrayBuffer)byteSequence;
            out.write(bab.buffer(), 0, bab.length());
        } else {
            out.write(byteSequence.toByteArray());
        }
    }
}

